/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.network;

import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.network.MessageHandlerWrapper;
import com.brandon3055.draconicevolution.entity.EntityLootCore;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketLootSync
implements IMessage {
    private int entityID;
    private Map<ItemStack, Integer> map;

    public PacketLootSync() {
    }

    public PacketLootSync(int entityID, Map<ItemStack, Integer> map) {
        this.entityID = entityID;
        this.map = map;
    }

    public void fromBytes(ByteBuf buf) {
        this.entityID = buf.readInt();
        this.map = new HashMap<ItemStack, Integer>();
        int count = buf.readInt();
        for (int i = 0; i < count; ++i) {
            ItemStack stack = ByteBufUtils.readItemStack((ByteBuf)buf);
            this.map.put(stack, buf.readInt());
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityID);
        buf.writeInt(this.map.size());
        for (ItemStack stack : this.map.keySet()) {
            NBTTagCompound tag = new NBTTagCompound();
            stack.func_77955_b(tag);
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)stack);
            buf.writeInt(this.map.get(stack).intValue());
        }
    }

    public static class Handler
    extends MessageHandlerWrapper<PacketLootSync, IMessage> {
        public IMessage handleMessage(PacketLootSync message, MessageContext ctx) {
            Entity entity = BrandonsCore.proxy.getClientWorld().func_73045_a(message.entityID);
            if (entity instanceof EntityLootCore) {
                ((EntityLootCore)entity).displayMap = message.map;
            }
            return null;
        }
    }
}

