/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.foamfix.coremod.patches;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.HashSet;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;

public class BlockPosPatch {
    private static final BiMap<String, String> mutableFieldSwaps = HashBiMap.create();
    private static final HashSet<String> mutableDeletedMethods = new HashSet();
    private static final HashSet<String> mutableOwners = new HashSet();

    public static ClassNode patchVec3i(ClassNode node) {
        for (FieldNode fn : node.fields) {
            if (!"I".equals(fn.desc) || fn.access != 18) continue;
            fn.access = 4;
        }
        return node;
    }

    public static ClassVisitor patchOtherClass(ClassVisitor next) {
        return new BlockPosClassVisitor(327680, next);
    }

    static {
        mutableFieldSwaps.put((Object)"x", (Object)"x");
        mutableFieldSwaps.put((Object)"y", (Object)"y");
        mutableFieldSwaps.put((Object)"z", (Object)"z");
        mutableFieldSwaps.put((Object)"field_177997_b", (Object)"field_177962_a");
        mutableFieldSwaps.put((Object)"field_177998_c", (Object)"field_177960_b");
        mutableFieldSwaps.put((Object)"field_177996_d", (Object)"field_177961_c");
        mutableDeletedMethods.add("getX");
        mutableDeletedMethods.add("getY");
        mutableDeletedMethods.add("getZ");
        mutableDeletedMethods.add("func_177958_n");
        mutableDeletedMethods.add("func_177956_o");
        mutableDeletedMethods.add("func_177952_p");
        mutableOwners.add("net/minecraft/util/math/BlockPos$MutableBlockPos");
    }

    private static class BlockPosMethodVisitor
    extends MethodVisitor {
        private final BlockPosClassVisitor classVisitor;

        public BlockPosMethodVisitor(int api, BlockPosClassVisitor cv, MethodVisitor mv) {
            super(api, mv);
            this.classVisitor = cv;
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            if (mutableOwners.contains(owner)) {
                String dst = (String)mutableFieldSwaps.get((Object)name);
                if (dst != null) {
                    if (this.mv != null) {
                        this.mv.visitFieldInsn(opcode, "net/minecraft/util/math/Vec3i", dst, desc);
                    }
                    this.classVisitor.hasChanged = true;
                } else if (this.mv != null) {
                    this.mv.visitFieldInsn(opcode, owner, name, desc);
                }
            } else if (this.mv != null) {
                this.mv.visitFieldInsn(opcode, owner, name, desc);
            }
        }
    }

    private static class BlockPosClassVisitor
    extends ClassVisitor {
        private boolean isMutable;
        private boolean isVec3i;
        private boolean hasChanged = false;

        public BlockPosClassVisitor(int api, ClassVisitor next) {
            super(api, next);
        }

        public void setCV(ClassVisitor visitor) {
            this.cv = visitor;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.isMutable = "net/minecraft/util/math/BlockPos$MutableBlockPos".equals(name);
            this.isVec3i = "net/minecraft/util/math/Vec3i".equals(name);
            if (mutableOwners.contains(superName)) {
                mutableOwners.add(name);
            }
            if (this.cv != null) {
                this.cv.visit(version, access, name, signature, superName, interfaces);
            }
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            if (this.cv == null) {
                return null;
            }
            if (this.isVec3i && mutableFieldSwaps.containsValue((Object)name)) {
                return this.cv.visitField(access & 0xFFFFFFE8 | 4, name, desc, signature, value);
            }
            if (!this.isMutable || !mutableFieldSwaps.containsKey((Object)name)) {
                return this.cv.visitField(access, name, desc, signature, value);
            }
            return null;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (!this.isMutable || !mutableDeletedMethods.contains(name)) {
                return new BlockPosMethodVisitor(this.api, this, this.cv != null ? this.cv.visitMethod(access, name, desc, signature, exceptions) : null);
            }
            return null;
        }
    }
}

