/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.api;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class AdvancedRocketryBiomes {
    public static final AdvancedRocketryBiomes instance = new AdvancedRocketryBiomes();
    private List<Biome> registeredBiomes = new ArrayList<Biome>();
    private List<Biome> registeredHighPressureBiomes = new LinkedList<Biome>();
    private List<Biome> registeredSingleBiome;
    private static List<Integer> blackListedBiomeIds;
    public static Biome moonBiome;
    public static Biome hotDryBiome;
    public static Biome alienForest;
    public static Biome spaceBiome;
    public static Biome stormLandsBiome;
    public static Biome crystalChasms;
    public static Biome swampDeepBiome;
    public static Biome marsh;
    public static Biome oceanSpires;
    public static Biome moonBiomeDark;
    public static Biome volcanic;
    public static Biome volcanicBarren;

    private AdvancedRocketryBiomes() {
        blackListedBiomeIds = new ArrayList<Integer>();
        this.registeredSingleBiome = new ArrayList<Biome>();
    }

    public void registerBiome(Biome biome, IForgeRegistry<Biome> iForgeRegistry) {
        this.registeredBiomes.add(biome);
        iForgeRegistry.register((IForgeRegistryEntry)biome);
    }

    public void registerBlackListBiome(Biome biome) {
        blackListedBiomeIds.add(Biome.func_185362_a((Biome)biome));
    }

    public List<Integer> getBlackListedBiomes() {
        return blackListedBiomeIds;
    }

    public void registerHighPressureBiome(Biome biome) {
        this.registeredHighPressureBiomes.add(biome);
        this.registerBlackListBiome(biome);
    }

    public List<Biome> getHighPressureBiomes() {
        return this.registeredHighPressureBiomes;
    }

    public void registerSingleBiome(Biome biome) {
        if (!blackListedBiomeIds.contains(Biome.func_185362_a((Biome)biome))) {
            this.registeredSingleBiome.add(biome);
        }
    }

    public void blackListVanillaBiomes() {
        for (int i = 0; i < 40; ++i) {
            blackListedBiomeIds.add(i);
        }
        blackListedBiomeIds.add(127);
        blackListedBiomeIds.add(129);
        blackListedBiomeIds.add(130);
        blackListedBiomeIds.add(131);
        blackListedBiomeIds.add(132);
        blackListedBiomeIds.add(133);
        blackListedBiomeIds.add(134);
        blackListedBiomeIds.add(140);
        blackListedBiomeIds.add(149);
        blackListedBiomeIds.add(151);
        blackListedBiomeIds.add(155);
        blackListedBiomeIds.add(156);
        blackListedBiomeIds.add(157);
        blackListedBiomeIds.add(158);
        blackListedBiomeIds.add(160);
        blackListedBiomeIds.add(161);
        blackListedBiomeIds.add(162);
        blackListedBiomeIds.add(163);
        blackListedBiomeIds.add(164);
        blackListedBiomeIds.add(165);
        blackListedBiomeIds.add(166);
        blackListedBiomeIds.add(167);
    }

    public List<Biome> getSingleBiome() {
        return this.registeredSingleBiome;
    }

    public Biome getBiomeById(int id) {
        for (Biome biome : this.registeredBiomes) {
            if (Biome.func_185362_a((Biome)biome) != id) continue;
            return biome;
        }
        return Biome.func_150568_d((int)id);
    }

    public static Biome getBiome(String string) {
        int id = 0;
        Biome biome = (Biome)Biome.field_185377_q.func_82594_a((Object)new ResourceLocation(string));
        if (biome == null) {
            id = Integer.parseInt(string);
            biome = Biome.func_180276_a((int)id, null);
        }
        return biome;
    }
}

