/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.block;

import java.util.HashMap;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import zmaster587.advancedRocketry.api.AreaBlob;
import zmaster587.advancedRocketry.api.util.IBlobHandler;
import zmaster587.advancedRocketry.atmosphere.AtmosphereHandler;
import zmaster587.advancedRocketry.tile.TileSeal;
import zmaster587.libVulpes.util.HashedBlockPosition;

public class BlockSeal
extends Block {
    private HashMap<HashedBlockPosition, BlobHandler> blobList = new HashMap();

    public BlockSeal(Material materialIn) {
        super(materialIn);
    }

    public void clearMap() {
        this.blobList.clear();
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileSeal();
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        super.func_180663_b(worldIn, pos, state);
        AtmosphereHandler atmhandler = AtmosphereHandler.getOxygenHandler(worldIn.field_73011_w.getDimension());
        if (atmhandler == null) {
            return;
        }
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            BlobHandler handler = this.blobList.remove(new HashedBlockPosition(pos.func_177972_a(dir)));
            if (handler != null) {
                atmhandler.unregisterBlob(handler);
            }
            this.fireCheckAllDirections(worldIn, pos.func_177972_a(dir), dir);
        }
    }

    public void removeSeal(World worldIn, BlockPos pos) {
        AtmosphereHandler atmhandler = AtmosphereHandler.getOxygenHandler(worldIn.field_73011_w.getDimension());
        if (atmhandler == null) {
            return;
        }
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            BlobHandler handler = this.blobList.remove(new HashedBlockPosition(pos.func_177972_a(dir)));
            if (handler == null) continue;
            atmhandler.unregisterBlob(handler);
        }
    }

    public void clearBlob(World worldIn, BlockPos pos, IBlockState state) {
        AtmosphereHandler atmhandler = AtmosphereHandler.getOxygenHandler(worldIn.field_73011_w.getDimension());
        if (atmhandler == null) {
            return;
        }
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            BlobHandler handler = this.blobList.remove(new HashedBlockPosition(pos.func_177972_a(dir)));
            if (handler == null) continue;
            atmhandler.unregisterBlob(handler);
        }
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176213_c(worldIn, pos, state);
        this.checkCompleteness(worldIn, pos);
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            this.fireCheckAllDirections(worldIn, pos.func_177972_a(dir), dir);
        }
    }

    public void fireCheckAllDirections(World worldIn, BlockPos startBlock, EnumFacing directionFrom) {
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            if (directionFrom.func_176734_d() == dir) continue;
            this.fireCheck(worldIn, startBlock.func_177972_a(dir));
        }
    }

    private void fireCheck(World worldIn, BlockPos pos) {
        Block block = worldIn.func_180495_p(pos).func_177230_c();
        if (block == this) {
            BlockSeal blockSeal = (BlockSeal)block;
            blockSeal.checkCompleteness(worldIn, pos);
        }
    }

    private boolean checkCompleteness(World worldIn, BlockPos pos) {
        AtmosphereHandler atmhandler = AtmosphereHandler.getOxygenHandler(worldIn.field_73011_w.getDimension());
        if (atmhandler == null) {
            return false;
        }
        if (worldIn.func_180495_p(pos.func_177984_a().func_177976_e()).func_177230_c() == this && worldIn.func_180495_p(pos.func_177984_a().func_177974_f()).func_177230_c() == this && worldIn.func_180495_p(pos.func_177984_a().func_177984_a()).func_177230_c() == this || worldIn.func_180495_p(pos.func_177984_a().func_177978_c()).func_177230_c() == this && worldIn.func_180495_p(pos.func_177984_a().func_177968_d()).func_177230_c() == this && worldIn.func_180495_p(pos.func_177984_a().func_177984_a()).func_177230_c() == this && !this.blobList.containsKey(new HashedBlockPosition(pos.func_177984_a()))) {
            pos = pos.func_177984_a();
            HashedBlockPosition hashPos = new HashedBlockPosition(pos);
            BlobHandler handler = new BlobHandler(worldIn, pos);
            this.blobList.put(hashPos, handler);
            AreaBlob blob = new AreaBlob(handler);
            blob.addBlock(hashPos, new LinkedList<AreaBlob>());
            atmhandler.registerBlob(handler, pos, blob);
            return true;
        }
        if (worldIn.func_180495_p(pos.func_177974_f().func_177978_c()).func_177230_c() == this && worldIn.func_180495_p(pos.func_177974_f().func_177968_d()).func_177230_c() == this && worldIn.func_180495_p(pos.func_177974_f().func_177974_f()).func_177230_c() == this && !this.blobList.containsKey(new HashedBlockPosition(pos.func_177974_f()))) {
            pos = pos.func_177974_f();
            HashedBlockPosition hashPos = new HashedBlockPosition(pos);
            BlobHandler handler = new BlobHandler(worldIn, pos);
            this.blobList.put(hashPos, handler);
            AreaBlob blob = new AreaBlob(handler);
            blob.addBlock(hashPos, new LinkedList<AreaBlob>());
            atmhandler.registerBlob(handler, pos, blob);
            return true;
        }
        return false;
    }

    private static class BlobHandler
    implements IBlobHandler {
        World world;
        BlockPos pos;

        public BlobHandler(World world, BlockPos pos) {
            this.world = world;
            this.pos = pos;
        }

        @Override
        public boolean canFormBlob() {
            return true;
        }

        @Override
        public World getWorldObj() {
            return this.world;
        }

        @Override
        public boolean canBlobsOverlap(HashedBlockPosition blockPosition, AreaBlob blob) {
            return false;
        }

        @Override
        public int getMaxBlobRadius() {
            return 0;
        }

        @Override
        public HashedBlockPosition getRootPosition() {
            return new HashedBlockPosition(this.pos);
        }

        @Override
        public int getTraceDistance() {
            return -1;
        }
    }
}

