/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.integration.jei;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import zmaster587.libVulpes.interfaces.IRecipe;
import zmaster587.libVulpes.recipe.RecipesMachine;

public class MachineRecipe
extends BlankRecipeWrapper {
    private List<List<ItemStack>> ingredients;
    private ArrayList<ItemStack> result;
    private ArrayList<RecipesMachine.ChanceItemStack> resultChance;
    private List<FluidStack> fluidIngredients;
    private List<FluidStack> fluidOutputs;
    private int energy;
    private int time;

    protected MachineRecipe(IRecipe rec) {
        if (rec instanceof RecipesMachine.Recipe) {
            this.resultChance = new ArrayList(((RecipesMachine.Recipe)rec).getChanceOutputs());
            this.result = new ArrayList();
            int i = -1;
            float totalChance = 0.0f;
            for (RecipesMachine.ChanceItemStack stack : this.resultChance) {
                totalChance += stack.chance;
            }
            for (RecipesMachine.ChanceItemStack stack : this.resultChance) {
                ++i;
                if (stack.chance == 0.0f) {
                    this.result.add(stack.stack.func_77946_l());
                    continue;
                }
                ItemStack stack2 = stack.stack.func_77946_l();
                stack2.func_151001_c(String.format("%s   Chance: %.1f%%", stack2.func_82833_r(), Float.valueOf(100.0f * stack.chance / totalChance)));
                this.result.add(stack2);
            }
        } else {
            this.result = new ArrayList(rec.getOutput());
        }
        this.ingredients = rec.getIngredients();
        this.energy = rec.getPower();
        this.time = rec.getTime();
        this.fluidIngredients = rec.getFluidIngredients();
        this.fluidOutputs = rec.getFluidOutputs();
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(ItemStack.class, this.ingredients);
        ingredients.setOutputs(ItemStack.class, this.result);
        ingredients.setInputs(FluidStack.class, this.fluidIngredients);
        ingredients.setOutputs(FluidStack.class, this.fluidOutputs);
    }

    public List<ItemStack> getResults() {
        return this.result;
    }

    public List<List<ItemStack>> getInputs() {
        return this.ingredients;
    }

    public int getEnergy() {
        return this.energy;
    }

    public int getTime() {
        return this.time;
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        String powerString = String.format("Power: %d RF/t", this.energy);
        FontRenderer fontRendererObj = minecraft.field_71466_p;
        int stringWidth = fontRendererObj.func_78256_a(powerString);
        fontRendererObj.func_78276_b(powerString, 0, 55, Color.black.getRGB());
        String timeString = String.format("Time: %d s", this.time / 20);
        stringWidth = fontRendererObj.func_78256_a(powerString);
        fontRendererObj.func_78276_b(timeString, recipeWidth - 55, 55, Color.black.getRGB());
    }
}

