/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.item;

import io.netty.buffer.ByteBuf;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.api.satellite.SatelliteBase;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.inventory.TextureResources;
import zmaster587.advancedRocketry.item.ItemSatelliteIdentificationChip;
import zmaster587.advancedRocketry.network.PacketSatellite;
import zmaster587.advancedRocketry.satellite.SatelliteBiomeChanger;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.api.IUniversalEnergy;
import zmaster587.libVulpes.inventory.GuiHandler;
import zmaster587.libVulpes.inventory.modules.IButtonInventory;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleButton;
import zmaster587.libVulpes.inventory.modules.ModuleContainerPan;
import zmaster587.libVulpes.inventory.modules.ModuleImage;
import zmaster587.libVulpes.inventory.modules.ModulePower;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.INetworkItem;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketItemModifcation;

public class ItemBiomeChanger
extends ItemSatelliteIdentificationChip
implements IModularInventory,
IButtonInventory,
INetworkItem {
    public List<ModuleBase> getModules(int id, EntityPlayer player) {
        LinkedList<ModuleBase> list = new LinkedList<ModuleBase>();
        SatelliteBiomeChanger sat = (SatelliteBiomeChanger)this.getSatellite(player.func_184586_b(EnumHand.MAIN_HAND));
        if (player.field_70170_p.field_72995_K) {
            list.add((ModuleBase)new ModuleImage(24, 14, TextureResources.earthCandyIcon));
        }
        LinkedList<ModuleButton> list2 = new LinkedList<ModuleButton>();
        int j = 0;
        for (byte biomeByte : sat.discoveredBiomes()) {
            Biome biome = Biome.func_150568_d((int)biomeByte);
            String biomeName = AdvancedRocketry.proxy.getNameFromBiome(biome);
            list2.add(new ModuleButton(32, 16 + 24 * j++, Biome.func_185362_a((Biome)biome), biomeName, (IButtonInventory)this, zmaster587.libVulpes.inventory.TextureResources.buttonBuild));
        }
        ModuleContainerPan pan = new ModuleContainerPan(32, 16, list2, new LinkedList(), null, 128, 128, 0, -64, 0, 1000);
        list.add((ModuleBase)pan);
        list.add((ModuleBase)new ModuleButton(120, 124, -1, LibVulpes.proxy.getLocalizedString("msg.biomechanger.scan"), (IButtonInventory)this, zmaster587.libVulpes.inventory.TextureResources.buttonScan));
        list.add((ModuleBase)new ModulePower(16, 48, (IUniversalEnergy)sat));
        return list;
    }

    @Override
    public void func_77624_a(ItemStack stack, World player, List list, ITooltipFlag arg5) {
        SatelliteBase sat = DimensionManager.getInstance().getSatellite(this.getSatelliteId(stack));
        SatelliteBiomeChanger mapping = null;
        if (sat instanceof SatelliteBiomeChanger) {
            mapping = (SatelliteBiomeChanger)sat;
        }
        if (!stack.func_77942_o()) {
            list.add(LibVulpes.proxy.getLocalizedString("msg.unprogrammed"));
        } else if (mapping == null) {
            list.add(LibVulpes.proxy.getLocalizedString("msg.biomechanger.nosat"));
        } else if (mapping.getDimensionId() == player.field_73011_w.getDimension()) {
            list.add(LibVulpes.proxy.getLocalizedString("msg.connected"));
            list.add(LibVulpes.proxy.getLocalizedString("msg.biomechanger.selBiome") + Biome.func_150568_d((int)mapping.getBiome()).func_185359_l());
            list.add(LibVulpes.proxy.getLocalizedString("msg.biomechanger.numBiome") + mapping.discoveredBiomes().size());
        } else {
            list.add(LibVulpes.proxy.getLocalizedString("msg.notconnected"));
        }
        super.func_77624_a(stack, player, list, arg5);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        SatelliteBase sat;
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K && (sat = DimensionManager.getInstance().getSatellite(this.getSatelliteId(stack))) != null) {
            if (player.func_70093_af()) {
                if (this.getSatellite(stack) != null) {
                    PacketHandler.sendToPlayer((BasePacket)new PacketSatellite(this.getSatellite(stack)), (EntityPlayer)player);
                    player.openGui((Object)LibVulpes.instance, GuiHandler.guiId.MODULARNOINV.ordinal(), world, -1, -1, 0);
                }
            } else {
                sat.performAction(player, world, player.func_180425_c());
            }
        }
        return super.func_77659_a(world, player, hand);
    }

    private int getBiomeId(ItemStack stack) {
        SatelliteBase sat = this.getSatellite(stack);
        if (sat != null && sat instanceof SatelliteBiomeChanger) {
            return ((SatelliteBiomeChanger)sat).getBiome();
        }
        return -1;
    }

    private void setBiomeId(ItemStack stack, int id) {
        SatelliteBase sat;
        if (Biome.func_150568_d((int)id) != null && (sat = this.getSatellite(stack)) != null && sat instanceof SatelliteBiomeChanger) {
            ((SatelliteBiomeChanger)sat).setBiome(id);
        }
    }

    public String getModularInventoryName() {
        return "item.biomeChanger.name";
    }

    public boolean canInteractWithContainer(EntityPlayer entity) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void onInventoryButtonPressed(int buttonId) {
        ItemStack stack = Minecraft.func_71410_x().field_71439_g.func_184586_b(EnumHand.MAIN_HAND);
        if (stack != null && stack.func_77973_b() == this) {
            this.setBiomeId(stack, buttonId);
            PacketHandler.sendToServer((BasePacket)new PacketItemModifcation((INetworkItem)this, (EntityPlayer)Minecraft.func_71410_x().field_71439_g, (byte)(buttonId == -1 ? -1 : 0)));
        }
    }

    public void writeDataToNetwork(ByteBuf out, byte id, ItemStack stack) {
        if (id == 0) {
            out.writeInt(this.getBiomeId(stack));
        }
    }

    public void readDataFromNetwork(ByteBuf in, byte packetId, NBTTagCompound nbt, ItemStack stack) {
        if (packetId == 0) {
            nbt.func_74768_a("biome", in.readInt());
        }
    }

    public void useNetworkData(EntityPlayer player, Side side, byte id, NBTTagCompound nbt, ItemStack stack) {
        if (id == -1) {
            ((SatelliteBiomeChanger)this.getSatellite(stack)).addBiome(Biome.func_185362_a((Biome)player.field_70170_p.func_180494_b(new BlockPos((int)player.field_70165_t, 0, (int)player.field_70161_v))));
            player.func_71053_j();
        }
        if (id == 0) {
            int biomeId = nbt.func_74762_e("biome");
            this.setBiomeId(stack, biomeId);
            player.func_71053_j();
        }
    }
}

