/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.satellite;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.SatelliteRegistry;
import zmaster587.advancedRocketry.api.satellite.SatelliteBase;
import zmaster587.advancedRocketry.api.satellite.SatelliteProperties;
import zmaster587.libVulpes.api.IUniversalEnergyTransmitter;
import zmaster587.libVulpes.util.UniversalBattery;

public class SatelliteEnergy
extends SatelliteBase
implements IUniversalEnergyTransmitter {
    UniversalBattery battery;
    long lastActionTime;
    byte teir;

    @Override
    public boolean acceptsItemInConstruction(ItemStack item) {
        int flag = SatelliteRegistry.getSatelliteProperty(item).getPropertyFlag();
        return super.acceptsItemInConstruction(item) || SatelliteProperties.Property.BATTERY.isOfType(flag) || SatelliteProperties.Property.POWER_GEN.isOfType(flag);
    }

    @Override
    public void setProperties(ItemStack satelliteProperties) {
        super.setProperties(satelliteProperties);
        this.battery = new UniversalBattery(Math.max(this.satelliteProperties.getPowerStorage(), 1));
    }

    @Override
    public String getInfo(World world) {
        return "Collecting Energy";
    }

    protected int energyCreated(World world, boolean simulate) {
        int amt = (int)((world.func_82737_E() - this.lastActionTime) * (long)this.getPowerPerTick());
        if (!simulate) {
            this.lastActionTime = world.func_82737_E();
        }
        return amt;
    }

    public int getPowerPerTick() {
        return this.satelliteProperties.getPowerGeneration();
    }

    @Override
    public String getName() {
        return "Microwave Energy Satellite";
    }

    @Override
    public boolean performAction(EntityPlayer player, World world, BlockPos pos) {
        return false;
    }

    @Override
    public double failureChance() {
        return 0.0;
    }

    public int getEnergyMTU(EnumFacing side) {
        return (int)(100.0f * ARConfiguration.getCurrentConfig().microwaveRecieverMulitplier);
    }

    @Override
    public void setDimensionId(World world) {
        super.setDimensionId(world);
        this.lastActionTime = world.func_82737_E();
    }

    public int transmitEnergy(EnumFacing dir, boolean simulate) {
        WorldServer world;
        if (this.getDimensionId() != -2147483647 && (world = DimensionManager.getWorld((int)this.getDimensionId())) != null) {
            int energyCreated = this.energyCreated((World)world, simulate);
            this.battery.acceptEnergy(Math.max(energyCreated - this.getEnergyMTU(EnumFacing.DOWN), 0), simulate);
            int energy = this.battery.extractEnergy(Math.max(this.getEnergyMTU(EnumFacing.DOWN) - energyCreated, 0), simulate);
            return energy + energyCreated;
        }
        return 0;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        this.battery.writeToNBT(nbt);
        nbt.func_74772_a("lastActionTime", this.lastActionTime);
        nbt.func_74774_a("teir", this.teir);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        if (this.battery == null) {
            this.battery = new UniversalBattery();
        }
        this.battery.readFromNBT(nbt);
        if (this.battery.getMaxEnergyStored() != this.satelliteProperties.getPowerStorage() || this.battery.getMaxEnergyStored() == 0) {
            this.battery.setMaxEnergyStored(Math.max(this.satelliteProperties.getPowerStorage(), 1));
        }
        this.lastActionTime = nbt.func_74763_f("lastActionTime");
        this.teir = nbt.func_74771_c("teir");
    }
}

