/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile.multiblock;

import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.stations.ISpaceObject;
import zmaster587.advancedRocketry.stations.SpaceObjectManager;
import zmaster587.advancedRocketry.stations.SpaceStationObject;
import zmaster587.libVulpes.api.LibVulpesBlocks;
import zmaster587.libVulpes.api.material.AllowedProducts;
import zmaster587.libVulpes.api.material.MaterialRegistry;
import zmaster587.libVulpes.block.BlockMeta;
import zmaster587.libVulpes.tile.multiblock.TileMultiBlock;

public class TileWarpCore
extends TileMultiBlock {
    private SpaceStationObject station;
    public static final Object[][][] structure = new Object[][][]{{{"blockTitanium", "blockTitanium", "blockTitanium"}, {"blockTitanium", Character.valueOf('I'), "blockTitanium"}, {"blockTitanium", "blockTitanium", "blockTitanium"}}, {{null, new BlockMeta(LibVulpesBlocks.blockStructureBlock), null}, {new BlockMeta(LibVulpesBlocks.blockStructureBlock), new BlockMeta(Blocks.field_150340_R), new BlockMeta(LibVulpesBlocks.blockStructureBlock)}, {null, new BlockMeta(LibVulpesBlocks.blockStructureBlock), null}}, {{"blockTitanium", Character.valueOf('c'), "blockTitanium"}, {"blockTitanium", new BlockMeta(Blocks.field_150340_R), "blockTitanium"}, {"blockTitanium", "blockTitanium", "blockTitanium"}}};

    private SpaceStationObject getSpaceObject() {
        ISpaceObject object;
        if (this.station == null && this.field_145850_b.field_73011_w.getDimension() == ARConfiguration.getCurrentConfig().spaceDimId && (object = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(this.field_174879_c)) instanceof SpaceStationObject) {
            this.station = (SpaceStationObject)object;
        }
        return this.station;
    }

    public Object[][][] getStructure() {
        return structure;
    }

    public boolean shouldHideBlock(World world, BlockPos pos, IBlockState tile) {
        return pos.compareTo((Vec3i)this.field_174879_c) == 0;
    }

    public void onInventoryUpdated() {
        if (this.itemInPorts.isEmpty()) {
            this.attemptCompleteStructure(this.field_145850_b.func_180495_p(this.field_174879_c));
        }
        if (this.getSpaceObject() == null || this.getSpaceObject().getFuelAmount() == this.getSpaceObject().getMaxFuelAmount()) {
            return;
        }
        for (IInventory inv : this.itemInPorts) {
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack stack = inv.func_70301_a(i);
                int amt = 0;
                if (stack == null || !OreDictionary.itemMatches((ItemStack)MaterialRegistry.getItemStackFromMaterialAndType((String)"Dilithium", (AllowedProducts)AllowedProducts.getProductByName((String)"GEM")), (ItemStack)stack, (boolean)false)) continue;
                int stackSize = stack.func_190916_E();
                amt = !this.field_145850_b.field_72995_K ? this.getSpaceObject().addFuel(ARConfiguration.getCurrentConfig().fuelPointsPerDilithium * stack.func_190916_E()) : Math.min(this.getSpaceObject().getFuelAmount() + 10 * stack.func_190916_E(), this.getSpaceObject().getMaxFuelAmount()) - this.getSpaceObject().getFuelAmount();
                inv.func_70298_a(i, amt / 10);
                inv.func_70296_d();
                if (stackSize / 10 == amt) continue;
                return;
            }
        }
    }

    public String getMachineName() {
        return "tile.warpCore.name";
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c.func_177982_a(-2, -2, -2), this.field_174879_c.func_177982_a(2, 2, 2));
    }
}

