/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.traits;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import slimeknights.tconstruct.library.traits.AbstractTrait;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.shared.client.ParticleEffect;
import slimeknights.tconstruct.tools.TinkerTools;

public class TraitSpiky
extends AbstractTrait {
    public TraitSpiky() {
        super("spiky", TextFormatting.DARK_GREEN);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void onPlayerHurt(ItemStack tool, EntityPlayer player, EntityLivingBase attacker, LivingHurtEvent event) {
        this.dealSpikyDamage(false, tool, player, (Entity)attacker, event);
    }

    @Override
    public void onBlock(ItemStack tool, EntityPlayer player, LivingHurtEvent event) {
        Entity target = event.getSource().func_76346_g();
        this.dealSpikyDamage(true, tool, player, target, event);
    }

    private void dealSpikyDamage(boolean isBlocking, ItemStack tool, EntityPlayer player, Entity target, LivingHurtEvent event) {
        if (target instanceof EntityLivingBase && target.func_70089_S() && target != player && !this.isThornsDamage(event.getSource())) {
            float damage = ToolHelper.getActualDamage(tool, (EntityLivingBase)player);
            if (!isBlocking) {
                damage /= 2.0f;
            }
            EntityDamageSource damageSource = new EntityDamageSource(DamageSource.field_76367_g.field_76373_n, (Entity)player);
            damageSource.func_76348_h();
            damageSource.func_151518_m();
            damageSource.func_180138_v();
            int oldHurtResistantTime = target.field_70172_ad;
            if (TraitSpiky.attackEntitySecondary((DamageSource)damageSource, damage, target, true, false)) {
                TinkerTools.proxy.spawnEffectParticle(ParticleEffect.Type.HEART_CACTUS, target, 1);
            }
            target.field_70172_ad = oldHurtResistantTime;
        }
    }

    private boolean isThornsDamage(DamageSource damageSource) {
        return damageSource instanceof EntityDamageSource && ((EntityDamageSource)damageSource).func_180139_w();
    }
}

