/*
 * Decompiled with CFR 0.152.
 */
package info.openmods.calc.parsing;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;

public class StringEscaper {
    public static final BiMap<Character, Character> ESCAPES = ImmutableBiMap.builder().put((Object)Character.valueOf('\\'), (Object)Character.valueOf('\\')).put((Object)Character.valueOf('\''), (Object)Character.valueOf('\'')).put((Object)Character.valueOf('\"'), (Object)Character.valueOf('\"')).put((Object)Character.valueOf('0'), (Object)Character.valueOf('\u0000')).put((Object)Character.valueOf('b'), (Object)Character.valueOf('\b')).put((Object)Character.valueOf('t'), (Object)Character.valueOf('\t')).put((Object)Character.valueOf('n'), (Object)Character.valueOf('\n')).put((Object)Character.valueOf('f'), (Object)Character.valueOf('\f')).put((Object)Character.valueOf('r'), (Object)Character.valueOf('\r')).build();

    public static String escapeString(String value, char delimiter, Set<Character> nonEscapeChars) {
        StringBuilder builder = new StringBuilder();
        builder.append(delimiter);
        int pos = 0;
        while (pos < value.length()) {
            char ch;
            if (nonEscapeChars.contains(Character.valueOf(ch = value.charAt(pos++)))) {
                builder.append(ch);
                continue;
            }
            Character possibleEscape = (Character)ESCAPES.inverse().get((Object)Character.valueOf(ch));
            if (possibleEscape != null) {
                builder.append("\\").append(possibleEscape);
                continue;
            }
            if (ch >= ' ' && ch < '\u007f') {
                builder.append(ch);
                continue;
            }
            if (ch <= '\u00ff') {
                builder.append(String.format("\\x%02X", ch));
                continue;
            }
            if (!Character.isHighSurrogate(ch)) {
                builder.append(String.format("\\u%04X", ch));
                continue;
            }
            Preconditions.checkState((pos < value.length() ? 1 : 0) != 0, (Object)"Malformed UTF-16 string: high surrogate at end of string");
            char nextCh = value.charAt(pos++);
            Preconditions.checkState((boolean)Character.isLowSurrogate(nextCh), (String)"Malformed UTF-16 string: expected low surrogate, got: %s", (Object)Integer.toHexString(nextCh));
            int codePoint = Character.toCodePoint(ch, nextCh);
            builder.append(String.format("\\U%08X", codePoint));
        }
        builder.append(delimiter);
        return builder.toString();
    }

    public static Pair<String, Integer> unescapeDelimitedString(String input, int start) {
        StringBuilder result = new StringBuilder();
        int pos = start;
        char delimiter = input.charAt(pos++);
        while (true) {
            char ch;
            if (pos >= input.length()) {
                throw new IllegalArgumentException("Unterminated string: '" + result + "'");
            }
            if ((ch = input.charAt(pos++)) == delimiter) break;
            if (ch == '\\') {
                if (pos >= input.length()) {
                    throw new IllegalArgumentException("Unterminated escape sequence: '" + result + "'");
                }
                char escaped = input.charAt(pos++);
                switch (escaped) {
                    case 'x': {
                        result.append(StringEscaper.parseHexChar(input, pos, 2));
                        pos += 2;
                        break;
                    }
                    case 'u': {
                        result.append(StringEscaper.parseHexChar(input, pos, 4));
                        pos += 4;
                        break;
                    }
                    case 'U': {
                        result.append(StringEscaper.parseHexChar(input, pos, 8));
                        pos += 8;
                        break;
                    }
                    default: {
                        Character sub = (Character)ESCAPES.get((Object)Character.valueOf(escaped));
                        Preconditions.checkArgument((sub != null ? 1 : 0) != 0, (Object)("Invalid escape sequence: " + escaped));
                        result.append(sub);
                        break;
                    }
                }
                continue;
            }
            result.append(ch);
        }
        return Pair.of((Object)result.toString(), (Object)pos);
    }

    private static char[] parseHexChar(String input, int pos, int digits) {
        String code = input.substring(pos, pos + digits);
        int intCode = Integer.parseInt(code, 16);
        return Character.toChars(intCode);
    }
}

