/*
 * Decompiled with CFR 0.152.
 */
package info.openmods.calc.types.multi;

import com.google.common.collect.ImmutableSet;
import info.openmods.calc.Frame;
import info.openmods.calc.FrameFactory;
import info.openmods.calc.IValuePrinter;
import info.openmods.calc.PositionalNotationPrinter;
import info.openmods.calc.PrinterUtils;
import info.openmods.calc.math.Complex;
import info.openmods.calc.parsing.StringEscaper;
import info.openmods.calc.types.bigint.BigIntPrinter;
import info.openmods.calc.types.fp.DoublePrinter;
import info.openmods.calc.types.multi.Cons;
import info.openmods.calc.types.multi.MetaObject;
import info.openmods.calc.types.multi.Symbol;
import info.openmods.calc.types.multi.TypedValue;
import info.openmods.calc.utils.config.ConfigProperty;
import java.math.BigInteger;
import java.util.Set;

public class TypedValuePrinter
implements IValuePrinter<TypedValue> {
    private static final Set<Character> UNESCAPED_CHARS = ImmutableSet.of((Object)Character.valueOf('\''));
    @ConfigProperty
    public int base = 10;
    @ConfigProperty
    public boolean uniformBaseNotation = false;
    @ConfigProperty
    public boolean allowStandardPrinter = false;
    @ConfigProperty
    public boolean escapeStrings = false;
    @ConfigProperty
    public boolean numericBool = false;
    @ConfigProperty
    public boolean printTypes = false;
    @ConfigProperty
    public boolean printLists = true;
    @ConfigProperty
    public boolean printNilInLists = false;
    private final PositionalNotationPrinter<Double> doublePrinter = new DoublePrinter.Helper(8);
    private final PositionalNotationPrinter<BigInteger> bigIntPrinter = new BigIntPrinter.Helper(0);
    private final TypedValue nullValue;

    public TypedValuePrinter(TypedValue nullValue) {
        this.nullValue = nullValue;
    }

    @Override
    public String str(TypedValue value) {
        String contents;
        MetaObject.SlotStr slotStr = value.getMetaObject().slotStr;
        if (slotStr != null) {
            Frame<TypedValue> frame = FrameFactory.createTopFrame();
            contents = slotStr.str(value, frame);
        } else {
            contents = value.value.toString();
        }
        return this.printTypes ? "(" + value.type + ")" + contents : contents;
    }

    @Override
    public String repr(TypedValue value) {
        MetaObject.SlotRepr slotRepr = value.getMetaObject().slotRepr;
        if (slotRepr != null) {
            Frame<TypedValue> frame = FrameFactory.createTopFrame();
            return slotRepr.repr(value, frame);
        }
        return value.value.toString();
    }

    @Override
    public String str(boolean value) {
        return this.numericBool ? (value ? "1" : "0") : (value ? "true" : "false");
    }

    @Override
    public String repr(boolean value) {
        return value ? "true" : "false";
    }

    @Override
    public String str(String value) {
        return this.escapeStrings ? StringEscaper.escapeString(value, '\"', UNESCAPED_CHARS) : value;
    }

    @Override
    public String repr(String value) {
        return StringEscaper.escapeString(value, '\"', UNESCAPED_CHARS);
    }

    @Override
    public String str(BigInteger value) {
        if (this.base < 2) {
            return "invalid radix";
        }
        return PrinterUtils.decorateBase(!this.uniformBaseNotation, this.base, this.base <= 36 ? value.toString(this.base) : this.bigIntPrinter.toString(value, this.base));
    }

    @Override
    public String repr(BigInteger value) {
        return this.str(value);
    }

    @Override
    public String str(Double value) {
        if (this.base == 10 && !this.allowStandardPrinter && !this.uniformBaseNotation) {
            return value.toString();
        }
        if (value.isNaN()) {
            return "NaN";
        }
        if (value.isInfinite()) {
            return value > 0.0 ? "+Inf" : "-Inf";
        }
        String result = this.doublePrinter.toString(value, this.base);
        return PrinterUtils.decorateBase(!this.uniformBaseNotation, this.base, result);
    }

    @Override
    public String repr(Double value) {
        return this.str(value);
    }

    @Override
    public String str(Complex value) {
        return this.str(value.re) + "+" + this.str(value.im) + "I";
    }

    @Override
    public String repr(Complex value) {
        return this.str(value);
    }

    @Override
    public String str(Cons cons) {
        if (this.printLists) {
            final StringBuilder result = new StringBuilder();
            cons.visit(new Cons.BranchingVisitor(){

                @Override
                public void begin() {
                    result.append("[");
                }

                @Override
                public void value(TypedValue value, boolean isLast) {
                    result.append(TypedValuePrinter.this.str(value));
                    if (!isLast) {
                        result.append(" ");
                    }
                }

                @Override
                public Cons.BranchingVisitor nestedValue(TypedValue value) {
                    result.append("[");
                    return this;
                }

                @Override
                public void end(TypedValue terminator) {
                    if (terminator.value != TypedValuePrinter.this.nullValue || TypedValuePrinter.this.printNilInLists) {
                        result.append(" . ");
                        result.append(TypedValuePrinter.this.str(terminator));
                    }
                    result.append("]");
                }
            });
            return result.toString();
        }
        return "(" + this.str(cons.car) + " . " + this.str(cons.cdr) + ")";
    }

    @Override
    public String repr(Cons cons) {
        return this.repr(cons.car) + " : " + this.repr(cons.cdr);
    }

    @Override
    public String str(Symbol s) {
        return s.value;
    }

    @Override
    public String repr(Symbol s) {
        return '#' + s.value;
    }
}

