/*
 * Decompiled with CFR 0.152.
 */
package openmods.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;

public class MappedModelLoader
implements ICustomModelLoader {
    private final Map<String, IModel> models;
    private final String modid;

    public static Builder builder() {
        return new Builder();
    }

    private MappedModelLoader(String modid, Map<String, IModel> models) {
        this.modid = modid;
        this.models = models;
    }

    public void func_110549_a(IResourceManager resourceManager) {
    }

    public boolean accepts(ResourceLocation modelLocation) {
        return this.modid.equals(modelLocation.func_110624_b()) && this.models.containsKey(modelLocation.func_110623_a());
    }

    public IModel loadModel(ResourceLocation modelLocation) throws Exception {
        return this.models.get(modelLocation.func_110623_a());
    }

    public static class Builder {
        private final ImmutableMap.Builder<String, IModel> modelsBuilder = ImmutableMap.builder();

        public Builder put(String id, IModel model) {
            this.modelsBuilder.put((Object)id, (Object)model);
            this.modelsBuilder.put((Object)("models/block/" + id), (Object)model);
            this.modelsBuilder.put((Object)("models/item/" + id), (Object)model);
            return this;
        }

        public MappedModelLoader build(String modid) {
            Preconditions.checkNotNull((Object)modid);
            return new MappedModelLoader(modid, (Map)this.modelsBuilder.build());
        }
    }
}

