/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.api.imc;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.event.FMLInterModComms;

public class MessageRouter {
    protected static Map<String, Method> handlers = new HashMap<String, Method>();

    public static void route(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage message : event.getMessages()) {
            Method handler = handlers.get(message.key);
            if (handler != null) {
                try {
                    handler.invoke((Object)message, new Object[0]);
                }
                catch (IllegalAccessException e) {
                    FMLLog.warning((String)"IllegalAccessException while handling message <%s>, ignoring. Error: %s", (Object[])new Object[]{message.key, e.getMessage()});
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    FMLLog.warning((String)"IllegalArgumentException while handling message <%s>, ignoring. Error: %s", (Object[])new Object[]{message.key, e.getMessage()});
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    FMLLog.warning((String)"InvocationTargetException while handling message <%s>, ignoring. Error: %s", (Object[])new Object[]{message.key, e.getMessage()});
                    e.printStackTrace();
                }
                continue;
            }
            FMLLog.warning((String)"Received an InterModComms event with an unrecognized key <%s>", (Object[])new Object[]{message.key});
        }
    }

    public static void register(String key, Method handler) {
        handlers.put(key, handler);
    }
}

