/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.tileentity;

import erogenousbeef.bigreactors.client.gui.GuiReactorRedNetPort;
import erogenousbeef.bigreactors.common.BRLog;
import erogenousbeef.bigreactors.common.CircuitType;
import erogenousbeef.bigreactors.common.multiblock.MultiblockReactor;
import erogenousbeef.bigreactors.common.multiblock.interfaces.ITickableMultiblockPart;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorControlRod;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorPart;
import erogenousbeef.bigreactors.gui.container.ContainerBasic;
import erogenousbeef.bigreactors.net.helpers.RedNetChange;
import it.zerono.mods.zerocore.lib.block.ModTileEntity;
import it.zerono.mods.zerocore.lib.world.WorldHelper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.fml.common.Optional;

@Optional.InterfaceList(value={@Optional.Interface(iface="erogenousbeef.bigreactors.common.multiblock.interfaces.ITickableMultiblockPart", modid="minefactoryreloaded")})
public class TileEntityReactorRedNetPort
extends TileEntityReactorPart
implements ITickableMultiblockPart {
    protected static final int minInputEnumValue = CircuitType.inputActive.ordinal();
    protected static final int maxInputEnumValue = CircuitType.inputEjectWaste.ordinal();
    protected static final int minOutputEnumValue = CircuitType.outputFuelTemperature.ordinal();
    protected static final int maxOutputEnumValue = CircuitType.outputEnergyAmount.ordinal();
    protected CircuitType[] channelCircuitTypes = new CircuitType[16];
    protected BlockPos[] coordMappings = new BlockPos[16];
    protected boolean[] inputActivatesOnPulse = new boolean[16];
    protected int[] oldValue = new int[16];
    public static final int CHANNELS_COUNT = 16;
    private int ticksSinceLastUpdate;

    public TileEntityReactorRedNetPort() {
        for (int i = 0; i < 16; ++i) {
            this.channelCircuitTypes[i] = CircuitType.DISABLED;
            this.coordMappings[i] = null;
            this.inputActivatesOnPulse[i] = false;
            this.oldValue[i] = 0;
        }
        this.ticksSinceLastUpdate = 0;
    }

    public Object getServerGuiElement(int guiId, EntityPlayer player) {
        return new ContainerBasic();
    }

    public Object getClientGuiElement(int guiId, EntityPlayer player) {
        return new GuiReactorRedNetPort(new ContainerBasic(), this);
    }

    public boolean canOpenGui(World world, BlockPos posistion, IBlockState state) {
        return true;
    }

    public int[] getOutputValues() {
        int[] outputs = new int[16];
        for (int i = 0; i < 16; ++i) {
            outputs[i] = this.getValueForChannel(i);
        }
        return outputs;
    }

    public int getValueForChannel(int channel) {
        if (channel < 0 || channel >= 16) {
            return 0;
        }
        if (!this.isConnected()) {
            return 0;
        }
        switch (this.channelCircuitTypes[channel]) {
            case outputFuelTemperature: {
                return (int)Math.floor(this.getReactorController().getFuelHeat());
            }
            case outputCasingTemperature: {
                return (int)Math.floor(this.getReactorController().getReactorHeat());
            }
            case outputFuelMix: {
                MultiblockReactor controller = this.getReactorController();
                return (int)Math.floor((float)controller.getFuelAmount() / (float)controller.getCapacity() * 100.0f);
            }
            case outputFuelAmount: {
                return this.getReactorController().getFuelAmount();
            }
            case outputWasteAmount: {
                return this.getReactorController().getWasteAmount();
            }
            case outputEnergyAmount: {
                MultiblockReactor reactor = this.getReactorController();
                if (reactor != null) {
                    return reactor.getEnergyStoredPercentage();
                }
                return 0;
            }
        }
        return 0;
    }

    public void onInputValuesChanged(int[] newValues) {
        for (int i = 0; i < newValues.length; ++i) {
            this.onInputValueChanged(i, newValues[i]);
        }
    }

    public void onInputValueChanged(int channel, int newValue) {
        if (channel < 0 || channel >= 16) {
            return;
        }
        CircuitType type = this.channelCircuitTypes[channel];
        if (!TileEntityReactorRedNetPort.isInput(type)) {
            return;
        }
        if (!this.isConnected()) {
            return;
        }
        if (newValue == this.oldValue[channel]) {
            return;
        }
        boolean isPulse = this.oldValue[channel] == 0 && newValue != 0;
        MultiblockReactor reactor = null;
        switch (type) {
            case inputActive: {
                boolean newActive;
                reactor = this.getReactorController();
                if (this.inputActivatesOnPulse[channel]) {
                    if (!isPulse) break;
                    reactor.setActive(!reactor.getActive());
                    break;
                }
                boolean bl = newActive = newValue != 0;
                if (newActive == reactor.getActive()) break;
                reactor.setActive(newActive);
                break;
            }
            case inputSetControlRod: {
                newValue = Math.min(100, Math.max(0, newValue));
                if (newValue == this.oldValue[channel]) {
                    return;
                }
                if (this.coordMappings[channel] != null) {
                    this.setControlRodInsertion(channel, this.coordMappings[channel], newValue);
                    break;
                }
                reactor = this.getReactorController();
                reactor.setAllControlRodInsertionValues(newValue);
                break;
            }
            case inputEjectWaste: {
                if (!isPulse) break;
                reactor = this.getReactorController();
                reactor.ejectWaste(false, null);
            }
        }
        this.oldValue[channel] = newValue;
    }

    @Override
    @Optional.Method(modid="minefactoryreloaded")
    public void onMultiblockServerTick() {
    }

    public CircuitType getChannelCircuitType(int channel) {
        if (channel < 0 || channel >= 16) {
            return CircuitType.DISABLED;
        }
        return this.channelCircuitTypes[channel];
    }

    public BlockPos getMappedCoord(int channel) {
        return this.coordMappings[channel];
    }

    public boolean isInputActivatedOnPulse(int channel) {
        return this.inputActivatesOnPulse[channel];
    }

    protected void clearChannel(int channel) {
        this.channelCircuitTypes[channel] = CircuitType.DISABLED;
        this.coordMappings[channel] = null;
        this.inputActivatesOnPulse[channel] = false;
        this.oldValue[channel] = 0;
    }

    protected TileEntity getMappedTileEntity(int channel) {
        if (channel < 0 || channel >= 16) {
            return null;
        }
        BlockPos coord = this.coordMappings[channel];
        if (coord == null || !WorldHelper.blockChunkExists((IChunkProvider)this.func_145831_w().func_72863_F(), (BlockPos)coord)) {
            return null;
        }
        return this.func_145831_w().func_175625_s(coord);
    }

    protected void setControlRodInsertion(int channel, BlockPos position, int newValue) {
        if (!this.isConnected()) {
            return;
        }
        if (!WorldHelper.blockChunkExists((IChunkProvider)this.func_145831_w().func_72863_F(), (BlockPos)position)) {
            return;
        }
        TileEntity te = this.func_145831_w().func_175625_s(position);
        if (te instanceof TileEntityReactorControlRod) {
            ((TileEntityReactorControlRod)te).setControlRodInsertion((short)newValue);
        } else {
            this.clearChannel(channel);
        }
    }

    protected void syncDataTo(NBTTagCompound data, ModTileEntity.SyncReason syncReason) {
        super.syncDataTo(data, syncReason);
        NBTTagList tagArray = new NBTTagList();
        for (int i = 0; i < 16; ++i) {
            tagArray.func_74742_a((NBTBase)this.encodeChannelSetting(i));
        }
        data.func_74782_a("redNetConfig", (NBTBase)tagArray);
    }

    protected void syncDataFrom(NBTTagCompound data, ModTileEntity.SyncReason syncReason) {
        super.syncDataFrom(data, syncReason);
        NBTTagList tagArray = data.func_150295_c("redNetConfig", 10);
        for (int i = 0; i < tagArray.func_74745_c(); ++i) {
            this.decodeChannelSetting(tagArray.func_150305_b(i));
        }
    }

    private NBTTagCompound encodeChannelSetting(int channel) {
        BlockPos coord;
        NBTTagCompound entry = new NBTTagCompound();
        entry.func_74768_a("channel", channel);
        entry.func_74768_a("setting", this.channelCircuitTypes[channel].ordinal());
        if (TileEntityReactorRedNetPort.isInput(this.channelCircuitTypes[channel]) && CircuitType.canBeToggledBetweenPulseAndNormal(this.channelCircuitTypes[channel])) {
            entry.func_74757_a("pulse", this.inputActivatesOnPulse[channel]);
        }
        if (CircuitType.hasCoordinate(this.channelCircuitTypes[channel]) && (coord = this.coordMappings[channel]) != null) {
            entry.func_74768_a("x", coord.func_177958_n());
            entry.func_74768_a("y", coord.func_177956_o());
            entry.func_74768_a("z", coord.func_177952_p());
        }
        return entry;
    }

    private void decodeChannelSetting(NBTTagCompound settingTag) {
        int channel = settingTag.func_74762_e("channel");
        int settingIdx = settingTag.func_74762_e("setting");
        this.clearChannel(channel);
        this.channelCircuitTypes[channel] = CircuitType.values()[settingIdx];
        if (TileEntityReactorRedNetPort.isInput(this.channelCircuitTypes[channel]) && CircuitType.canBeToggledBetweenPulseAndNormal(this.channelCircuitTypes[channel])) {
            this.inputActivatesOnPulse[channel] = settingTag.func_74767_n("pulse");
        }
        if (CircuitType.hasCoordinate(this.channelCircuitTypes[channel]) && settingTag.func_74764_b("x") && settingTag.func_74764_b("y") && settingTag.func_74764_b("z")) {
            this.coordMappings[channel] = new BlockPos(settingTag.func_74762_e("x"), settingTag.func_74762_e("y"), settingTag.func_74762_e("z"));
        }
    }

    public void onCircuitUpdate(RedNetChange[] changes) {
        if (changes == null || changes.length < 1) {
            return;
        }
        for (int i = 0; i < changes.length; ++i) {
            CircuitType newType;
            int channelID = changes[i].getChannel();
            this.channelCircuitTypes[channelID] = newType = changes[i].getType();
            if (CircuitType.canBeToggledBetweenPulseAndNormal(newType)) {
                this.inputActivatesOnPulse[channelID] = changes[i].getPulseOrToggle();
            }
            if (CircuitType.hasCoordinate(newType)) {
                TileEntity te;
                BlockPos coord = changes[i].getCoord();
                if (coord != null && !((te = this.func_145831_w().func_175625_s(coord)) instanceof TileEntityReactorControlRod)) {
                    BRLog.warning("Invalid tile entity reference at coordinate %s - rednet circuit expected a control rod", coord);
                    coord = null;
                }
                this.coordMappings[channelID] = coord;
                continue;
            }
            this.coordMappings[channelID] = null;
        }
        WorldHelper.notifyBlockUpdate((World)this.func_145831_w(), (BlockPos)this.func_174877_v(), null, null);
        this.func_70296_d();
    }

    public static boolean isInput(CircuitType type) {
        return type.ordinal() >= minInputEnumValue && type.ordinal() <= maxInputEnumValue;
    }

    public static boolean isOutput(CircuitType type) {
        return type.ordinal() >= minOutputEnumValue && type.ordinal() <= maxOutputEnumValue;
    }
}

