/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbutilities.command;

import com.feed_the_beast.ftblib.lib.command.CmdBase;
import com.feed_the_beast.ftblib.lib.util.NBTUtils;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.nbt.NBTBase;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeChunkManager;

public class CmdDumpChunkloaders
extends CmdBase {
    public CmdDumpChunkloaders() {
        super("dump_chunkloaders", CmdBase.Level.OP_OR_SP);
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        for (WorldServer world : DimensionManager.getWorlds()) {
            HashSet set = new HashSet();
            for (Map.Entry entry : ForgeChunkManager.getPersistentChunksFor((World)world).entries()) {
                set.add(entry.getValue());
            }
            if (set.isEmpty()) continue;
            sender.func_145747_a((ITextComponent)new TextComponentString("- DIM " + world.field_73011_w.getDimension() + ":"));
            for (ForgeChunkManager.Ticket ticket : set) {
                TextComponentString title = new TextComponentString(String.format("#%08x", ticket.hashCode()));
                title.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString(ticket.getChunkList().size() + " chunks")));
                TextComponentString owner = new TextComponentString("Owner");
                owner.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString(ticket.getModId() + " : " + ticket.getEntity())));
                TextComponentString data = new TextComponentString("Data");
                data.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString(NBTUtils.getColoredNBTString((NBTBase)ticket.getModData()))));
                TextComponentString chunks = new TextComponentString("Chunks");
                int minX = Integer.MAX_VALUE;
                int minZ = Integer.MAX_VALUE;
                int maxX = Integer.MIN_VALUE;
                int maxZ = Integer.MIN_VALUE;
                for (ChunkPos pos : ticket.getChunkList()) {
                    if (pos.field_77276_a < minX) {
                        minX = pos.field_77276_a;
                    }
                    if (pos.field_77275_b < minZ) {
                        minZ = pos.field_77275_b;
                    }
                    if (pos.field_77276_a > maxX) {
                        maxX = pos.field_77276_a;
                    }
                    if (pos.field_77275_b <= maxZ) continue;
                    maxZ = pos.field_77275_b;
                }
                BlockPos pos = new BlockPos((minX + maxX) * 8 + 8, 255, (minZ + maxZ) * 8 + 8);
                world.func_175726_f(pos);
                pos = world.func_175672_r(pos);
                chunks.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString(pos + " ; " + ticket.getChunkList().toString())));
                chunks.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tp " + pos.func_177958_n() + " " + pos.func_177956_o() + " " + pos.func_177952_p()));
                sender.func_145747_a(new TextComponentString("").func_150257_a((ITextComponent)title).func_150258_a(" | ").func_150257_a((ITextComponent)owner).func_150258_a(" | ").func_150257_a((ITextComponent)data).func_150258_a(" | ").func_150257_a((ITextComponent)chunks));
            }
        }
    }
}

