/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.biome;

import biomesoplenty.api.biome.BiomeOwner;
import biomesoplenty.api.biome.IExtendedBiome;
import biomesoplenty.api.config.IBOPWorldSettings;
import biomesoplenty.api.config.IConfigObj;
import biomesoplenty.api.enums.BOPClimates;
import biomesoplenty.api.generation.GeneratorStage;
import biomesoplenty.api.generation.IGenerator;
import biomesoplenty.common.init.ModBiomes;
import biomesoplenty.common.world.GenerationManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public abstract class BOPBiome
extends Biome
implements IExtendedBiome {
    protected GenerationManager generationManager = new GenerationManager();
    protected Map<BOPClimates, Integer> weightMap = new HashMap<BOPClimates, Integer>();
    public int skyColor = -1;
    public int fogColor = -1;
    public float fogDensity = 1.0f;
    public boolean hasBiomeEssence = true;
    public final ResourceLocation location;
    public IConfigObj conf;

    private BOPBiome(ResourceLocation idLoc, PropsBuilder defaultBuilder, IConfigObj conf) {
        super((Biome.BiomeProperties)BOPBiome.configureBiomeProps(idLoc, defaultBuilder, conf));
        this.location = idLoc;
        this.conf = conf;
        this.field_76760_I.field_76832_z = -999;
        this.field_76760_I.field_76802_A = -999;
        this.field_76760_I.field_76803_B = -999;
        this.field_76760_I.field_76801_G = -999;
        this.field_76760_I.field_76805_H = -999;
    }

    protected BOPBiome(String idName, PropsBuilder defaultBuilder) {
        this(new ResourceLocation("biomesoplenty", idName), defaultBuilder, ModBiomes.readConfigFile(idName));
    }

    public static BiomeProps configureBiomeProps(ResourceLocation idLoc, PropsBuilder defaultBuilder, IConfigObj conf) {
        Boolean enableSnow;
        if (conf.isEmpty()) {
            return defaultBuilder.build();
        }
        defaultBuilder.withTemperature(conf.getFloat("temperature", Float.valueOf(defaultBuilder.temperature)));
        defaultBuilder.withRainfall(conf.getFloat("rainfall", Float.valueOf(defaultBuilder.rainfall)));
        defaultBuilder.withWaterColor(conf.getInt("waterColor", defaultBuilder.waterColor));
        Boolean enableRain = conf.getBool("enableRain", defaultBuilder.enableRain);
        if (enableRain != null && !enableRain.booleanValue()) {
            defaultBuilder.withRainDisabled();
        }
        if ((enableSnow = conf.getBool("enableSnow", defaultBuilder.enableSnow)) != null && enableSnow.booleanValue()) {
            defaultBuilder.withSnowEnabled();
        }
        defaultBuilder.withBaseBiome(conf.getString("baseBiome", defaultBuilder.baseBiomeRegName));
        defaultBuilder.withGuiColour(conf.getInt("guiColour", defaultBuilder.guiColour));
        return defaultBuilder.build();
    }

    @Override
    public void applySettings(IBOPWorldSettings settings) {
    }

    @Override
    public void configure(IConfigObj conf) {
        this.field_76752_A = conf.getBlockState("topBlock", this.field_76752_A);
        this.field_76753_B = conf.getBlockState("fillerBlock", this.field_76753_B);
        this.skyColor = conf.getInt("skyColor", this.skyColor);
        this.fogColor = conf.getInt("fogColor", this.fogColor);
        this.fogDensity = conf.getFloat("fogDensity", Float.valueOf(this.fogDensity)).floatValue();
        this.hasBiomeEssence = conf.getBool("hasBiomeEssence", this.hasBiomeEssence);
        IConfigObj confWeights = conf.getObject("weights");
        for (BOPClimates climate : BOPClimates.values()) {
            Integer weight = confWeights.getInt(climate.name().toLowerCase(Locale.ENGLISH), this.weightMap.get((Object)climate));
            if (weight == null) continue;
            if (weight < 1) {
                this.weightMap.remove((Object)climate);
                continue;
            }
            this.weightMap.put(climate, weight);
        }
        IConfigObj confGenerators = conf.getObject("generators");
        this.generationManager.configure(confGenerators);
        ArrayList<IConfigObj> confEntities = conf.getObjectArray("entities");
        if (confEntities != null) {
            for (IConfigObj confEntity : confEntities) {
                Biome.SpawnListEntry entry;
                String entityName = confEntity.getString("name");
                EnumCreatureType creatureType = confEntity.getEnum("creatureType", EnumCreatureType.class);
                if (entityName == null || creatureType == null) continue;
                Class entityClazz = ((EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(entityName))).getEntityClass();
                Class livingClazz = null;
                if (!entityClazz.isAssignableFrom(EntityLiving.class)) {
                    confEntity.addMessage("Entity " + entityName + " is not of type EntityLiving");
                    continue;
                }
                livingClazz = entityClazz;
                if (livingClazz == null) {
                    confEntity.addMessage("No entity registered called " + entityName);
                    continue;
                }
                if (!creatureType.func_75598_a().isAssignableFrom(livingClazz)) {
                    confEntity.addMessage("Entity " + entityName + " is not of type " + creatureType);
                    continue;
                }
                List spawns = this.func_76747_a(creatureType);
                Integer weight = confEntity.getInt("weight");
                if (weight != null && weight < 1) {
                    Iterator spawnIterator = spawns.iterator();
                    while (spawnIterator.hasNext()) {
                        entry = (Biome.SpawnListEntry)spawnIterator.next();
                        if (entry.field_76300_b != livingClazz) continue;
                        spawnIterator.remove();
                    }
                    continue;
                }
                boolean foundIt = false;
                for (Biome.SpawnListEntry entry2 : spawns) {
                    if (entry2.field_76300_b != entityClazz) continue;
                    entry2.field_76292_a = confEntity.getInt("weight", entry2.field_76292_a);
                    entry2.field_76301_c = confEntity.getInt("minGroupCount", entry2.field_76301_c);
                    entry2.field_76299_d = confEntity.getInt("maxGroupCount", entry2.field_76299_d);
                    foundIt = true;
                }
                if (foundIt) continue;
                entry = new Biome.SpawnListEntry(livingClazz, confEntity.getInt("weight", 10).intValue(), confEntity.getInt("minGroupCount", 4).intValue(), confEntity.getInt("maxGroupCount", 4).intValue());
                spawns.add(entry);
            }
        }
    }

    @Override
    public BiomeOwner getBiomeOwner() {
        return BiomeOwner.BIOMESOPLENTY;
    }

    @Override
    public void addGenerator(String name, GeneratorStage stage, IGenerator generator) {
        this.generationManager.addGenerator(name, stage, generator);
    }

    public IGenerator getGenerator(String name) {
        return this.generationManager.getGenerator(name);
    }

    public void removeGenerator(String name) {
        this.generationManager.removeGenerator(name);
    }

    @Override
    public GenerationManager getGenerationManager() {
        return this.generationManager;
    }

    @Override
    public Map<BOPClimates, Integer> getWeightMap() {
        return this.weightMap;
    }

    @Override
    public void addWeight(BOPClimates climate, int weight) {
        this.weightMap.put(climate, weight);
    }

    @Override
    public void clearWeights() {
        this.weightMap.clear();
    }

    public boolean hasBiomeEssence() {
        return this.hasBiomeEssence;
    }

    public int getFogColor(BlockPos pos) {
        return this.fogColor;
    }

    public float getFogDensity(BlockPos pos) {
        return this.fogDensity;
    }

    public int func_76731_a(float temperature) {
        return this.skyColor == -1 ? super.func_76731_a(temperature) : this.skyColor;
    }

    @Override
    public Biome getBaseBiome() {
        return this;
    }

    @Override
    public ResourceLocation getResourceLocation() {
        return this.location;
    }

    public static class BiomeProps
    extends Biome.BiomeProperties {
        private int guiColour = 0xFFFFFF;

        private BiomeProps(String name, float temperature, float rainfall, float baseHeight, float heightVariation, boolean enableRain, boolean enableSnow, int waterColor, String baseBiomeRegName, int guiColour) {
            super(name);
            this.func_185410_a(temperature);
            this.func_185395_b(rainfall);
            this.func_185398_c(baseHeight);
            this.func_185400_d(heightVariation);
            if (!enableRain) {
                this.func_185396_a();
            }
            if (enableSnow) {
                this.func_185411_b();
            }
            this.func_185402_a(waterColor);
            this.func_185399_a(baseBiomeRegName);
            this.guiColour = guiColour;
        }
    }

    public static class PropsBuilder {
        private final String biomeName;
        private int guiColour = 0xFFFFFF;
        private float baseHeight = 0.1f;
        private float heightVariation = 0.2f;
        private float temperature = 0.5f;
        private float rainfall = 0.5f;
        private int waterColor = 0xFFFFFF;
        private boolean enableSnow = false;
        private boolean enableRain = true;
        private String baseBiomeRegName;

        public PropsBuilder(String name) {
            this.biomeName = name;
        }

        public PropsBuilder withGuiColour(Integer colour) {
            if (colour != null) {
                this.guiColour = colour;
            }
            return this;
        }

        public PropsBuilder withTemperature(Float temperature) {
            if (temperature != null) {
                this.temperature = temperature.floatValue();
            }
            return this;
        }

        public PropsBuilder withRainfall(Float rainfall) {
            if (rainfall != null) {
                this.rainfall = rainfall.floatValue();
            }
            return this;
        }

        public PropsBuilder withBaseHeight(Float baseHeight) {
            if (baseHeight != null) {
                this.baseHeight = baseHeight.floatValue();
            }
            return this;
        }

        public PropsBuilder withHeightVariation(Float heightVariation) {
            if (heightVariation != null) {
                this.heightVariation = heightVariation.floatValue();
            }
            return this;
        }

        public PropsBuilder withRainDisabled() {
            this.enableRain = false;
            return this;
        }

        public PropsBuilder withSnowEnabled() {
            this.enableSnow = true;
            return this;
        }

        public PropsBuilder withWaterColor(Integer waterColor) {
            if (waterColor != null) {
                this.waterColor = waterColor;
            }
            return this;
        }

        public PropsBuilder withBaseBiome(String name) {
            if (name != null) {
                this.baseBiomeRegName = name;
            }
            return this;
        }

        public BiomeProps build() {
            return new BiomeProps(this.biomeName, this.temperature, this.rainfall, this.baseHeight, this.heightVariation, this.enableRain, this.enableSnow, this.waterColor, this.baseBiomeRegName, this.guiColour);
        }
    }
}

