/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world;

import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;

public class TerrainSettings {
    public double avgHeight = 0.0;
    public double variationBelow = 0.0;
    public double variationAbove = 0.0;
    public double sidewaysNoiseAmount = 0.0;
    public double[] octaveWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    public double minHeight = 0.0;
    public double maxHeight = 255.0;

    public TerrainSettings setDefaults() {
        this.avgHeight = 64.0;
        this.variationBelow = 10.0;
        this.variationAbove = 20.0;
        this.minHeight = 0.0;
        this.maxHeight = 255.0;
        this.sidewaysNoiseAmount = 0.4;
        PresetOctaveWeights.DEFAULT.copyWeights(this.octaveWeights);
        return this;
    }

    public TerrainSettings avgHeight(double a) {
        this.avgHeight = a;
        return this;
    }

    public TerrainSettings sidewaysNoise(double a) {
        this.sidewaysNoiseAmount = MathHelper.func_151237_a((double)a, (double)0.0, (double)1.0);
        return this;
    }

    public TerrainSettings heightVariation(double variation) {
        return this.heightVariation(variation, variation);
    }

    public TerrainSettings heightVariation(double varBelow, double varAbove) {
        this.variationBelow = varBelow;
        this.variationAbove = varAbove;
        return this;
    }

    public TerrainSettings minHeight(double minHeight) {
        this.minHeight = MathHelper.func_151237_a((double)minHeight, (double)0.0, (double)255.0);
        return this;
    }

    public TerrainSettings maxHeight(double maxHeight) {
        this.maxHeight = MathHelper.func_151237_a((double)maxHeight, (double)0.0, (double)255.0);
        return this;
    }

    public TerrainSettings octaves(double w0, double w1, double w2, double w3, double w4, double w5) {
        double norm = 1.0 / (1.0 * w0 + 2.0 * w1 + 4.0 * w2 + 8.0 * w3 + 6.0 * w4 + 3.0 * w5);
        this.octaveWeights[0] = w0 * 1.0 * norm;
        this.octaveWeights[1] = w1 * 2.0 * norm;
        this.octaveWeights[2] = w2 * 4.0 * norm;
        this.octaveWeights[3] = w3 * 8.0 * norm;
        this.octaveWeights[4] = w4 * 6.0 * norm;
        this.octaveWeights[5] = w5 * 3.0 * norm;
        return this;
    }

    public static TerrainSettings forVanillaBiome(Biome biome) {
        double avgHeight = 65.0f + 17.0f * biome.func_185355_j();
        double variationAbove = 7.0f + 80.0f * biome.func_185360_m();
        double variationBelow = 4.0f + 20.0f * biome.func_185360_m();
        return new TerrainSettings().setDefaults().avgHeight(avgHeight).heightVariation(variationAbove, variationBelow).sidewaysNoise(0.9);
    }

    public static enum PresetOctaveWeights {
        DEFAULT(new double[]{0.041666666666666664, 0.08333333333333333, 0.16666666666666666, 0.3333333333333333, 0.25, 0.125});

        private final double[] weights;

        private PresetOctaveWeights(double[] weights) {
            this.weights = weights;
        }

        public void copyWeights(double[] destination) {
            System.arraycopy(this.weights, 0, destination, 0, this.weights.length);
        }
    }
}

