/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.effect.fx;

import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.models.obj.OBJModelLibrary;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.client.util.resource.AbstractRenderableTexture;
import hellfirepvp.astralsorcery.client.util.resource.AssetLibrary;
import hellfirepvp.astralsorcery.client.util.resource.AssetLoader;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;

public class EntityFXCrystal
extends EntityComplexFX {
    private static final AbstractRenderableTexture texWhite = AssetLibrary.loadTexture(AssetLoader.TextureLocation.MODELS, "crystal_big_white");
    private static int lCrystal = -1;
    private double x;
    private double y;
    private double z;
    private double oldX;
    private double oldY;
    private double oldZ;
    private float scale = 1.0f;
    private float rX;
    private float rY;
    private float rZ;
    private EntityComplexFX.AlphaFunction fadeFunction = EntityComplexFX.AlphaFunction.CONSTANT;
    private EntityComplexFX.ScaleFunction scaleFunction = EntityComplexFX.ScaleFunction.IDENTITY;
    private float alphaMultiplier = 1.0f;
    private float colorRed = 1.0f;
    private float colorGreen = 1.0f;
    private float colorBlue = 1.0f;
    private double motionX = 0.0;
    private double motionY = 0.0;
    private double motionZ = 0.0;

    public EntityFXCrystal(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.oldX = x;
        this.oldY = y;
        this.oldZ = z;
    }

    public EntityFXCrystal updatePosition(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public EntityFXCrystal offset(double x, double y, double z) {
        this.x += x;
        this.y += y;
        this.z += z;
        return this;
    }

    public EntityFXCrystal rotation(float x, float y, float z) {
        this.rX = x;
        this.rY = y;
        this.rZ = z;
        return this;
    }

    public EntityFXCrystal setScaleFunction(@Nonnull EntityComplexFX.ScaleFunction scaleFunction) {
        this.scaleFunction = scaleFunction;
        return this;
    }

    public EntityFXCrystal enableAlphaFade(@Nonnull EntityComplexFX.AlphaFunction function) {
        this.fadeFunction = function;
        return this;
    }

    public EntityFXCrystal motion(double x, double y, double z) {
        this.motionX = x;
        this.motionY = y;
        this.motionZ = z;
        return this;
    }

    public EntityFXCrystal scale(float scale) {
        this.scale = scale;
        return this;
    }

    public EntityFXCrystal setAlphaMultiplier(float alphaMul) {
        this.alphaMultiplier = alphaMul;
        return this;
    }

    public EntityFXCrystal setColor(Color color) {
        this.colorRed = (float)color.getRed() / 255.0f;
        this.colorGreen = (float)color.getGreen() / 255.0f;
        this.colorBlue = (float)color.getBlue() / 255.0f;
        return this;
    }

    @Override
    public void tick() {
        super.tick();
        this.oldX = this.x;
        this.oldY = this.y;
        this.oldZ = this.z;
        this.x += this.motionX;
        this.y += this.motionY;
        this.z += this.motionZ;
    }

    @Override
    public void render(float pTicks) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179118_c();
        GlStateManager.func_179147_l();
        Blending.DEFAULT.applyStateManager();
        GlStateManager.func_179129_p();
        GlStateManager.func_179098_w();
        GlStateManager.func_179132_a((boolean)false);
        float alpha = this.fadeFunction.getAlpha(this.age, this.maxAge);
        GlStateManager.func_179131_c((float)this.colorRed, (float)this.colorGreen, (float)this.colorBlue, (float)(alpha *= this.alphaMultiplier));
        RenderingUtils.removeStandartTranslationFromTESRMatrix(pTicks);
        double iX = RenderingUtils.interpolate(this.oldX, this.x, pTicks);
        double iY = RenderingUtils.interpolate(this.oldY, this.y, pTicks);
        double iZ = RenderingUtils.interpolate(this.oldZ, this.z, pTicks);
        GlStateManager.func_179137_b((double)iX, (double)iY, (double)iZ);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)this.rX, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)this.rY, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)this.rZ, (float)0.0f, (float)0.0f, (float)1.0f);
        float fScale = this.scale;
        fScale = this.scaleFunction.getScale(this, new Vector3(iX, iY, iZ), pTicks, fScale);
        GlStateManager.func_179152_a((float)fScale, (float)fScale, (float)fScale);
        this.renderCrystal();
        GlStateManager.func_179084_k();
        Blending.DEFAULT.applyStateManager();
        GlStateManager.func_179141_d();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179089_o();
        GlStateManager.func_179121_F();
    }

    private void renderCrystal() {
        texWhite.bindTexture();
        if (lCrystal == -1) {
            lCrystal = GLAllocation.func_74526_a((int)1);
            GlStateManager.func_187423_f((int)lCrystal, (int)4864);
            OBJModelLibrary.bigCrystal.renderAll(true);
            GlStateManager.func_187415_K();
        }
        GlStateManager.func_179148_o((int)lCrystal);
    }
}

