/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.cape;

import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.cape.CapeArmorEffect;
import hellfirepvp.astralsorcery.common.constellation.cape.CapeEffectFactory;
import hellfirepvp.astralsorcery.common.constellation.cape.impl.CapeEffectAevitas;
import hellfirepvp.astralsorcery.common.constellation.cape.impl.CapeEffectArmara;
import hellfirepvp.astralsorcery.common.constellation.cape.impl.CapeEffectBootes;
import hellfirepvp.astralsorcery.common.constellation.cape.impl.CapeEffectDiscidia;
import hellfirepvp.astralsorcery.common.constellation.cape.impl.CapeEffectEvorsio;
import hellfirepvp.astralsorcery.common.constellation.cape.impl.CapeEffectFornax;
import hellfirepvp.astralsorcery.common.constellation.cape.impl.CapeEffectHorologium;
import hellfirepvp.astralsorcery.common.constellation.cape.impl.CapeEffectLucerna;
import hellfirepvp.astralsorcery.common.constellation.cape.impl.CapeEffectMineralis;
import hellfirepvp.astralsorcery.common.constellation.cape.impl.CapeEffectOctans;
import hellfirepvp.astralsorcery.common.constellation.cape.impl.CapeEffectPelotrio;
import hellfirepvp.astralsorcery.common.constellation.cape.impl.CapeEffectVicio;
import hellfirepvp.astralsorcery.common.data.config.Config;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;

public class CapeEffectRegistry {
    private static Map<IConstellation, CapeEffectFactory<? extends CapeArmorEffect>> armorEffectMap = new HashMap<IConstellation, CapeEffectFactory<? extends CapeArmorEffect>>();

    @Nullable
    public static CapeEffectFactory<? extends CapeArmorEffect> getArmorEffect(IConstellation cst) {
        return armorEffectMap.get(cst);
    }

    public static void registerCapeArmorEffect(IConstellation cst, Class<? extends CapeArmorEffect> armorEffectClass) {
        if (CapeEffectRegistry.getArmorEffect(cst) != null) {
            return;
        }
        armorEffectMap.put(cst, new CapeEffectFactory<CapeArmorEffect>(armorEffectClass));
    }

    public static void addDynamicConfigEntries() {
        Config.addDynamicEntry(new CapeEffectAevitas(new NBTTagCompound()));
        Config.addDynamicEntry(new CapeEffectDiscidia(new NBTTagCompound()));
        Config.addDynamicEntry(new CapeEffectEvorsio(new NBTTagCompound()));
        Config.addDynamicEntry(new CapeEffectArmara(new NBTTagCompound()));
        Config.addDynamicEntry(new CapeEffectVicio(new NBTTagCompound()));
        Config.addDynamicEntry(new CapeEffectLucerna(new NBTTagCompound()));
        Config.addDynamicEntry(new CapeEffectFornax(new NBTTagCompound()));
        Config.addDynamicEntry(new CapeEffectPelotrio(new NBTTagCompound()));
        Config.addDynamicEntry(new CapeEffectMineralis(new NBTTagCompound()));
        Config.addDynamicEntry(new CapeEffectOctans(new NBTTagCompound()));
        Config.addDynamicEntry(new CapeEffectHorologium(new NBTTagCompound()));
        Config.addDynamicEntry(new CapeEffectBootes(new NBTTagCompound()));
    }
}

