/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.perk.tree;

import hellfirepvp.astralsorcery.client.gui.perk.BatchPerkContext;
import hellfirepvp.astralsorcery.client.gui.perk.PerkRenderGroup;
import hellfirepvp.astralsorcery.client.gui.perk.group.PerkPointHaloRenderGroup;
import hellfirepvp.astralsorcery.client.util.BufferBatch;
import hellfirepvp.astralsorcery.client.util.resource.SpriteSheetResource;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.PerkTreePoint;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.nodes.MajorPerk;
import hellfirepvp.astralsorcery.common.util.data.Tuple;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PerkTreeMajor<T extends MajorPerk>
extends PerkTreePoint<T> {
    public PerkTreeMajor(T perk, Point offset) {
        super(perk, offset);
        this.setRenderSize((int)((double)this.getRenderSize() * 1.4));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addGroups(Collection<PerkRenderGroup> groups) {
        super.addGroups(groups);
        groups.add(PerkPointHaloRenderGroup.INSTANCE);
    }

    @Override
    @Nullable
    @SideOnly(value=Side.CLIENT)
    public Rectangle2D.Double renderPerkAtBatch(BatchPerkContext drawCtx, PerkTreePoint.AllocationStatus status, long spriteOffsetTick, float pTicks, double x, double y, double scale) {
        SpriteSheetResource tex = this.getHaloSprite(status);
        BatchPerkContext.TextureObjectGroup grp = PerkPointHaloRenderGroup.INSTANCE.getGroup(tex);
        if (grp == null) {
            return new Rectangle2D.Double();
        }
        BufferBatch buf = drawCtx.getContext(grp);
        BufferBuilder vb = buf.getBuffer();
        double haloSize = (double)this.getRenderSize() * 0.8 * scale;
        if (status == PerkTreePoint.AllocationStatus.ALLOCATED) {
            haloSize *= 1.5;
        }
        Vector3 starVec = new Vector3(x - haloSize, y - haloSize, 0.0);
        double uLength = tex.getULength();
        double vLength = tex.getVLength();
        Tuple<Double, Double> frameUV = tex.getUVOffset(spriteOffsetTick);
        for (int i = 0; i < 4; ++i) {
            int u = (i + 1 & 2) >> 1;
            int v = (i + 2 & 2) >> 1;
            Vector3 pos = starVec.clone().addX(haloSize * (double)u * 2.0).addY(haloSize * (double)v * 2.0);
            vb.func_181662_b(pos.getX(), pos.getY(), pos.getZ()).func_187315_a((Double)frameUV.key + uLength * (double)u, (Double)frameUV.value + vLength * (double)v).func_181666_a(1.0f, 1.0f, 1.0f, 0.85f).func_181675_d();
        }
        super.renderPerkAtBatch(drawCtx, status, spriteOffsetTick, pTicks, x, y, scale);
        double actualSize = (double)this.getRenderSize() * scale;
        return new Rectangle2D.Double(-actualSize, -actualSize, actualSize * 2.0, actualSize * 2.0);
    }
}

