/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.altar.recipes;

import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.common.crafting.ISpecialCraftingEffects;
import hellfirepvp.astralsorcery.common.crafting.altar.AbstractAltarRecipe;
import hellfirepvp.astralsorcery.common.crafting.altar.ActiveCraftingTask;
import hellfirepvp.astralsorcery.common.crafting.altar.recipes.ConstellationRecipe;
import hellfirepvp.astralsorcery.common.crafting.helper.AccessibleRecipe;
import hellfirepvp.astralsorcery.common.tile.TileAltar;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.util.Random;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EnchantmentAmuletRecipe
extends ConstellationRecipe
implements ISpecialCraftingEffects {
    public EnchantmentAmuletRecipe(AccessibleRecipe recipe) {
        super(recipe);
    }

    @Override
    public AbstractAltarRecipe copyNewEffectInstance() {
        return new EnchantmentAmuletRecipe(this.getNativeRecipe());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onCraftClientTick(TileAltar altar, ActiveCraftingTask.CraftingState state, long tick, Random rand) {
        super.onCraftClientTick(altar, state, tick, rand);
        if (state == ActiveCraftingTask.CraftingState.ACTIVE) {
            Vector3 altarPos = new Vector3(altar);
            EntityFXFacingParticle p = EffectHelper.genericFlareParticle(altarPos.getX() - 3.0 + (double)(rand.nextFloat() * 7.0f), altarPos.getY(), altarPos.getZ() - 3.0 + (double)(rand.nextFloat() * 7.0f));
            p.gravity(0.004).enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT).scale(rand.nextFloat() * 0.1f + 0.25f);
            p.setColor(new Color(Color.HSBtoRGB(rand.nextFloat() * 360.0f, 1.0f, 1.0f)));
            float percCycle = (float)((double)((float)(tick % 200L) / 200.0f * 2.0f) * Math.PI);
            int parts = 6;
            for (int i = 0; i < parts; ++i) {
                float angleSwirl = 110.0f;
                Vector3 center = new Vector3(altar).add(0.5, 1.1, 0.5);
                Vector3 v = new Vector3(1, 0, 0);
                float originalAngle = (float)i / (float)parts * 360.0f;
                double angle = originalAngle + MathHelper.func_76126_a((float)percCycle) * angleSwirl;
                v.rotate(Math.toRadians(angle), Vector3.RotAxis.Y_AXIS).normalize().multiply(2.2);
                Vector3 pos = center.clone().add(v);
                Vector3 mot = center.clone().subtract(pos).normalize().multiply(0.09);
                EntityFXFacingParticle particle = EffectHelper.genericFlareParticle(pos);
                particle.gravity(0.004).enableAlphaFade(EntityComplexFX.AlphaFunction.PYRAMID).scale(rand.nextFloat() * 0.4f + 0.15f);
                particle.setColor(Color.WHITE);
                particle.motion(mot.getX(), mot.getY(), mot.getZ());
                angleSwirl = 180.0f;
                center = new Vector3(altar).add(0.5, 0.1, 0.5);
                v = new Vector3(1, 0, 0);
                originalAngle = (float)i / (float)parts * 360.0f;
                angle = originalAngle + MathHelper.func_76126_a((float)percCycle) * angleSwirl;
                v.rotate(-Math.toRadians(angle), Vector3.RotAxis.Y_AXIS).normalize().multiply(4);
                pos = center.clone().add(v);
                mot = center.clone().subtract(pos).normalize().multiply(0.15);
                particle = EffectHelper.genericFlareParticle(pos);
                particle.gravity(0.004).enableAlphaFade(EntityComplexFX.AlphaFunction.PYRAMID).scale(rand.nextFloat() * 0.4f + 0.27f);
                particle.setMaxAge(50);
                particle.setColor(Color.WHITE);
                particle.motion(mot.getX(), mot.getY(), mot.getZ());
            }
        }
    }
}

