/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.grindstone;

import hellfirepvp.astralsorcery.common.crafting.ItemHandle;
import hellfirepvp.astralsorcery.common.util.ItemUtils;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;

public class GrindstoneRecipe {
    protected static final Random rand = new Random();
    protected final ItemHandle input;
    protected final ItemStack output;
    protected final int chance;
    protected final float doubleChance;

    public GrindstoneRecipe(ItemStack input, ItemStack output, int chance) {
        this(input, output, chance, 0.0f);
    }

    public GrindstoneRecipe(ItemHandle input, ItemStack output, int chance) {
        this(input, output, chance, 0.0f);
    }

    public GrindstoneRecipe(ItemStack input, ItemStack output, int chance, float doubleChance) {
        this.input = new ItemHandle(input);
        this.output = output;
        this.chance = chance;
        this.doubleChance = doubleChance;
    }

    public GrindstoneRecipe(ItemHandle input, ItemStack output, int chance, float doubleChance) {
        this.input = input;
        this.output = output;
        this.chance = chance;
        this.doubleChance = doubleChance;
    }

    public boolean matches(ItemStack stackIn) {
        return this.input.matchCrafting(stackIn);
    }

    public boolean isValid() {
        return this.input.getApplicableItems().size() > 0 && !this.output.func_190926_b();
    }

    public float getChanceToDoubleOutput() {
        return MathHelper.func_76131_a((float)this.doubleChance, (float)0.0f, (float)1.0f);
    }

    @Nonnull
    public GrindResult grind(ItemStack stackIn) {
        if (rand.nextInt(this.chance) == 0) {
            int out = this.output.func_190916_E();
            if (rand.nextFloat() <= this.getChanceToDoubleOutput()) {
                out *= 2;
            }
            return GrindResult.itemChange(ItemUtils.copyStackWithSize(this.output, out));
        }
        return GrindResult.failNoOp();
    }

    @Nonnull
    public ItemStack getOutputForMatching() {
        return this.output;
    }

    @Nonnull
    public ItemHandle getOutputForRender() {
        return new ItemHandle(this.output);
    }

    @Nonnull
    public ItemHandle getInputForRender() {
        return this.input;
    }

    public static enum ResultType {
        SUCCESS,
        ITEMCHANGE,
        FAIL_SILENT,
        FAIL_BREAK_ITEM;

    }

    public static class GrindResult {
        private final ResultType type;
        private final ItemStack stack;

        private GrindResult(ResultType type, ItemStack stack) {
            this.type = type;
            this.stack = stack;
        }

        public ResultType getType() {
            return this.type;
        }

        @Nonnull
        public ItemStack getStack() {
            return this.stack;
        }

        public static GrindResult success() {
            return new GrindResult(ResultType.SUCCESS, ItemStack.field_190927_a);
        }

        public static GrindResult itemChange(@Nonnull ItemStack newStack) {
            return new GrindResult(ResultType.ITEMCHANGE, newStack);
        }

        public static GrindResult failNoOp() {
            return new GrindResult(ResultType.FAIL_SILENT, ItemStack.field_190927_a);
        }

        public static GrindResult failBreakItem() {
            return new GrindResult(ResultType.FAIL_BREAK_ITEM, ItemStack.field_190927_a);
        }
    }
}

