/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.network.packet.server;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.constellation.perk.AbstractPerk;
import hellfirepvp.astralsorcery.common.constellation.perk.PerkEffectHelper;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.PerkTree;
import hellfirepvp.astralsorcery.common.util.ByteBufUtils;
import hellfirepvp.astralsorcery.common.util.log.LogCategory;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PktSyncPerkActivity
implements IMessage,
IMessageHandler<PktSyncPerkActivity, IMessage> {
    private AbstractPerk perk;
    private boolean unlock;
    private NBTTagCompound newData;
    private NBTTagCompound oldData;
    private Type type = null;

    public PktSyncPerkActivity() {
    }

    public PktSyncPerkActivity(AbstractPerk perk, boolean unlock) {
        this.perk = perk;
        this.unlock = unlock;
    }

    public PktSyncPerkActivity(Type type) {
        this.type = type;
    }

    public PktSyncPerkActivity(AbstractPerk perk, NBTTagCompound oldData, NBTTagCompound newData) {
        this.type = Type.DATACHANGE;
        this.perk = perk;
        this.oldData = oldData;
        this.newData = newData;
    }

    public void fromBytes(ByteBuf buf) {
        this.unlock = buf.readBoolean();
        this.type = ByteBufUtils.readOptional(buf, byteBuf -> ByteBufUtils.readEnumValue(byteBuf, Type.class));
        ResourceLocation key = ByteBufUtils.readOptional(buf, ByteBufUtils::readResourceLocation);
        if (key != null) {
            this.perk = PerkTree.PERK_TREE.getPerk(key);
        }
        this.newData = ByteBufUtils.readOptional(buf, ByteBufUtils::readNBTTag);
        this.oldData = ByteBufUtils.readOptional(buf, ByteBufUtils::readNBTTag);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.unlock);
        ByteBufUtils.writeOptional(buf, this.type, ByteBufUtils::writeEnumValue);
        ByteBufUtils.writeOptional(buf, this.perk, (byteBuf, perk) -> ByteBufUtils.writeResourceLocation(byteBuf, perk.getRegistryName()));
        ByteBufUtils.writeOptional(buf, this.newData, ByteBufUtils::writeNBTTag);
        ByteBufUtils.writeOptional(buf, this.oldData, ByteBufUtils::writeNBTTag);
    }

    public IMessage onMessage(PktSyncPerkActivity message, MessageContext ctx) {
        this.handleClientPerkUpdate(message);
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private void handleClientPerkUpdate(PktSyncPerkActivity pkt) {
        AstralSorcery.proxy.scheduleClientside(() -> {
            if (Minecraft.func_71410_x().field_71439_g != null) {
                if (pkt.type != null) {
                    LogCategory.PERKS.info(() -> "Received perk activity packet on clientside: " + (Object)((Object)pkt.type));
                    switch (pkt.type) {
                        case CLEARALL: {
                            PerkEffectHelper.EVENT_INSTANCE.clearAllPerksClient((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
                            break;
                        }
                        case UNLOCKALL: {
                            PerkEffectHelper.EVENT_INSTANCE.reapplyAllPerksClient((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
                            break;
                        }
                        case DATACHANGE: {
                            PerkEffectHelper.EVENT_INSTANCE.notifyPerkDataChangeClient((EntityPlayer)Minecraft.func_71410_x().field_71439_g, pkt.perk, pkt.oldData, pkt.newData);
                            break;
                        }
                    }
                } else if (pkt.perk != null) {
                    LogCategory.PERKS.info(() -> "Received perk modification packet on clientside: " + pkt.perk.getRegistryName() + " " + (pkt.unlock ? "Application" : "Removal"));
                    PerkEffectHelper.EVENT_INSTANCE.notifyPerkChange((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Side.CLIENT, pkt.perk, !pkt.unlock);
                }
            }
        });
    }

    public static enum Type {
        CLEARALL,
        UNLOCKALL,
        DATACHANGE;

    }
}

