/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util.data;

import hellfirepvp.astralsorcery.common.util.MiscUtils;
import java.util.Objects;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class WorldBlockPos
extends BlockPos {
    private final World world;

    public WorldBlockPos(World world, BlockPos pos) {
        super((Vec3i)pos);
        this.world = world;
    }

    public static WorldBlockPos wrap(TileEntity te) {
        return new WorldBlockPos(te.func_145831_w(), te.func_174877_v());
    }

    public static WorldBlockPos wrap(World world, BlockPos pos) {
        return new WorldBlockPos(world, pos);
    }

    public World getWorld() {
        return this.world;
    }

    public IBlockState getStateAt() {
        return this.world.func_180495_p((BlockPos)this);
    }

    public WorldBlockPos add(int x, int y, int z) {
        return WorldBlockPos.wrap(this.world, super.func_177982_a(x, y, z));
    }

    public WorldBlockPos add(double x, double y, double z) {
        return WorldBlockPos.wrap(this.world, super.func_177963_a(x, y, z));
    }

    public WorldBlockPos add(Vec3i vec) {
        return WorldBlockPos.wrap(this.world, super.func_177971_a(vec));
    }

    public <T extends TileEntity> T getTileAt(Class<T> tileClass, boolean forceChunkLoad) {
        return (T)((TileEntity)MiscUtils.getTileAt((IBlockAccess)this.world, this, tileClass, forceChunkLoad));
    }

    public boolean isChunkLoaded() {
        return MiscUtils.isChunkLoaded(this.world, new ChunkPos((BlockPos)this));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        WorldBlockPos that = (WorldBlockPos)((Object)o);
        return Objects.equals(this.world, that.world);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.world != null ? this.world.hashCode() : 0);
        return result;
    }
}

