/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.building;

import com.direwolf20.buildinggadgets.common.building.IPlacementSequence;
import com.direwolf20.buildinggadgets.common.building.RegionIterator;
import com.direwolf20.buildinggadgets.common.building.RegionSpliterator;
import com.google.common.base.MoreObjects;
import com.google.common.collect.PeekingIterator;
import java.util.Objects;
import java.util.Spliterator;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public final class Region
implements IPlacementSequence {
    private final int minX;
    private final int minY;
    private final int minZ;
    private final int maxX;
    private final int maxY;
    private final int maxZ;

    public Region(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.minX = Math.min(minX, maxX);
        this.minY = Math.min(minY, maxY);
        this.minZ = Math.min(minZ, maxZ);
        this.maxX = Math.max(minX, maxX);
        this.maxY = Math.max(minY, maxY);
        this.maxZ = Math.max(minZ, maxZ);
    }

    public Region(Vec3i vertex) {
        this(vertex, vertex);
    }

    public Region(Vec3i min, Vec3i max) {
        this(min.func_177958_n(), min.func_177956_o(), min.func_177952_p(), max.func_177958_n(), max.func_177956_o(), max.func_177952_p());
    }

    public Region translate(int x, int y, int z) {
        return new Region(this.minX + x, this.minY + y, this.minZ + z, this.maxX + x, this.maxY + y, this.maxZ + z);
    }

    public Region translate(Vec3i direction) {
        return this.translate(direction.func_177958_n(), direction.func_177956_o(), direction.func_177952_p());
    }

    public Region grow(int x, int y, int z) {
        return new Region(this.minX, this.minY, this.minZ, this.maxX + x, this.maxY + y, this.maxZ + z);
    }

    public Region grow(int size) {
        return this.grow(size, size, size);
    }

    public Region shrink(int x, int y, int z) {
        return this.grow(-x, -y, -z);
    }

    public Region shrink(int size) {
        return this.grow(-size);
    }

    public Region expand(int x, int y, int z) {
        return new Region(this.minX - x, this.minY - y, this.minZ - z, this.maxX + x, this.maxY + y, this.maxZ + z);
    }

    public Region expand(Vec3i vec) {
        return this.expand(vec.func_177958_n(), vec.func_177956_o(), vec.func_177952_p());
    }

    public Region expand(int size) {
        return this.expand(size, size, size);
    }

    public Region collapse(int x, int y, int z) {
        return this.expand(-x, -y, -z);
    }

    public Region collapse(Vec3i vec) {
        return this.collapse(vec.func_177958_n(), vec.func_177956_o(), vec.func_177952_p());
    }

    public Region collapse(int size) {
        return this.expand(-size);
    }

    public Region intersect(Region other) {
        int minX = Math.max(this.minX, other.minX);
        int minY = Math.max(this.minY, other.minY);
        int minZ = Math.max(this.minZ, other.minZ);
        int maxX = Math.min(this.maxX, other.maxX);
        int maxY = Math.min(this.maxY, other.maxY);
        int maxZ = Math.min(this.maxZ, other.maxZ);
        return new Region(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public Region union(Region other) {
        int minX = Math.min(this.minX, other.minX);
        int minY = Math.min(this.minY, other.minY);
        int minZ = Math.min(this.minZ, other.minZ);
        int maxX = Math.max(this.maxX, other.maxX);
        int maxY = Math.max(this.maxY, other.maxY);
        int maxZ = Math.max(this.maxZ, other.maxZ);
        return new Region(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public int getMinX() {
        return this.minX;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getMinZ() {
        return this.minZ;
    }

    public int getMaxX() {
        return this.maxX;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public int getMaxZ() {
        return this.maxZ;
    }

    public BlockPos getMin() {
        return new BlockPos(this.minX, this.minY, this.minZ);
    }

    public BlockPos getMax() {
        return new BlockPos(this.maxX, this.maxY, this.maxZ);
    }

    public int getXSize() {
        return Math.abs(this.maxX - this.minX) + 1;
    }

    public int getYSize() {
        return Math.abs(this.maxY - this.minY) + 1;
    }

    public int getZSize() {
        return Math.abs(this.maxZ - this.minZ) + 1;
    }

    public int size() {
        return this.getXSize() * this.getYSize() * this.getZSize();
    }

    public boolean containsX(int x) {
        return x >= this.minX && x <= this.maxX;
    }

    public boolean containsY(int y) {
        return y >= this.minY && y <= this.maxY;
    }

    public boolean containsZ(int z) {
        return z >= this.minZ && z <= this.maxZ;
    }

    @Override
    public boolean mayContain(int x, int y, int z) {
        return this.contains(x, y, z);
    }

    public boolean contains(int x, int y, int z) {
        return this.containsX(x) && this.containsY(y) && this.containsZ(z);
    }

    public boolean contains(Vec3i vec) {
        return this.mayContain(vec.func_177958_n(), vec.func_177956_o(), vec.func_177952_p());
    }

    public boolean intersectsWith(Region other) {
        return this.maxX >= other.minX && this.minX <= other.maxX && this.maxZ >= other.minZ && this.minZ <= other.maxZ && this.maxY >= other.minY && this.minY <= other.maxY;
    }

    @Override
    @Deprecated
    public Region copy() {
        return new Region(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }

    @Override
    public Region getBoundingBox() {
        return this;
    }

    @Override
    public PeekingIterator<BlockPos> iterator() {
        return new RegionIterator(this);
    }

    @Override
    public Spliterator<BlockPos> spliterator() {
        return new RegionSpliterator(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("minX", this.minX).add("minY", this.minY).add("minZ", this.minZ).add("maxX", this.maxX).add("maxY", this.maxY).add("maxZ", this.maxZ).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Region region = (Region)o;
        return this.minX == region.minX && this.minY == region.minY && this.minZ == region.minZ && this.maxX == region.maxX && this.maxY == region.maxY && this.maxZ == region.maxZ;
    }

    public int hashCode() {
        return Objects.hash(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }
}

