/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.building;

import com.direwolf20.buildinggadgets.common.building.Region;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.PeekingIterator;
import net.minecraft.util.math.BlockPos;

class RegionIterator
extends AbstractIterator<BlockPos>
implements PeekingIterator<BlockPos> {
    private final int minY;
    private final int minZ;
    private final int maxX;
    private final int maxY;
    private final int maxZ;
    private int posX;
    private int posY;
    private int posZ;

    RegionIterator(Region region) {
        this(region.getMinX(), region.getMinY(), region.getMinZ(), region.getMaxX(), region.getMaxY(), region.getMaxZ());
    }

    private RegionIterator(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
        this.posX = minX;
        this.posY = minY;
        this.posZ = minZ;
    }

    protected BlockPos computeNext() {
        if (this.isXOverflowed()) {
            return (BlockPos)this.endOfData();
        }
        BlockPos pos = new BlockPos(this.posX, this.posY, this.posZ);
        ++this.posZ;
        if (this.isZOverflowed()) {
            this.posZ = this.minZ;
            ++this.posY;
        } else {
            return pos;
        }
        if (this.isYOverflowed()) {
            this.posY = this.minY;
            ++this.posX;
        } else {
            return pos;
        }
        return pos;
    }

    private boolean isXOverflowed() {
        return this.posX > this.maxX;
    }

    private boolean isYOverflowed() {
        return this.posY > this.maxY;
    }

    private boolean isZOverflowed() {
        return this.posZ > this.maxZ;
    }
}

