/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.building;

import com.direwolf20.buildinggadgets.common.building.Region;
import com.direwolf20.buildinggadgets.common.tools.GadgetUtils;
import java.util.Comparator;
import java.util.Spliterator;
import java.util.function.Consumer;
import net.minecraft.util.math.BlockPos;

class RegionSpliterator
implements Spliterator<BlockPos> {
    private int minX;
    private int minY;
    private int minZ;
    private int maxX;
    private int maxY;
    private int maxZ;
    private int nextPosX;
    private int nextPosY;
    private int nextPosZ;
    private boolean allowYZSplit;

    RegionSpliterator(Region region) {
        this(region.getMinX(), region.getMinY(), region.getMinZ(), region.getMaxX(), region.getMaxY(), region.getMaxZ());
    }

    private RegionSpliterator(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this(minX, minY, minZ, maxX, maxY, maxZ, minX, minY, minZ, true);
    }

    private RegionSpliterator(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, int posX, int posY, int posZ, boolean allowYZSplit) {
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
        this.nextPosX = posX;
        this.nextPosY = posY;
        this.nextPosZ = posZ;
        this.allowYZSplit = allowYZSplit;
    }

    @Override
    public boolean tryAdvance(Consumer<? super BlockPos> action) {
        if (this.isXOverflowed()) {
            return false;
        }
        this.allowYZSplit = false;
        BlockPos pos = new BlockPos(this.nextPosX, this.nextPosY, this.nextPosZ);
        ++this.nextPosZ;
        if (this.isZOverflowed()) {
            this.nextPosZ = this.minZ;
            ++this.nextPosY;
        } else {
            action.accept((BlockPos)pos);
            return true;
        }
        if (this.isYOverflowed()) {
            this.nextPosY = this.minY;
            ++this.nextPosX;
        } else {
            action.accept((BlockPos)pos);
            return true;
        }
        action.accept((BlockPos)pos);
        return true;
    }

    @Override
    public Spliterator<BlockPos> trySplit() {
        int oldMinX = this.minX;
        int oldMinY = this.minY;
        int oldMinZ = this.minZ;
        int oldPosX = this.nextPosX;
        int oldPosY = this.nextPosY;
        int oldPosZ = this.nextPosZ;
        if (this.maxX > this.minX) {
            this.minX = (this.maxX - this.minX + 1) / 2 + this.minX + 1;
            this.resetPos();
            return new RegionSpliterator(oldMinX, oldMinY, oldMinZ, this.minX - 1, this.maxY, this.maxZ, oldPosX, oldPosY, oldPosZ, this.allowYZSplit);
        }
        if (this.maxY > this.minY && this.allowYZSplit) {
            this.minY = (this.maxY - this.minY + 1) / 2 + this.minY + 1;
            this.resetPos();
            return new RegionSpliterator(oldMinX, oldMinY, oldMinZ, this.maxX, this.minY - 1, this.maxZ, oldPosX, oldPosY, oldPosZ, this.allowYZSplit);
        }
        if (this.maxZ > this.minZ && this.allowYZSplit) {
            this.minZ = (this.maxZ - this.minZ + 1) / 2 + this.minZ + 1;
            this.resetPos();
            return new RegionSpliterator(oldMinX, oldMinY, oldMinZ, this.maxX, this.maxY, this.minZ - 1, oldPosX, oldPosY, oldPosZ, this.allowYZSplit);
        }
        return null;
    }

    @Override
    public long estimateSize() {
        return (Math.abs((long)this.maxX - (long)this.nextPosX) + 1L) * (Math.abs((long)this.maxY - (long)this.nextPosY) + 1L) * Math.abs((long)this.maxZ - (long)this.nextPosZ + 1L);
    }

    @Override
    public int characteristics() {
        return 17749;
    }

    @Override
    public Comparator<? super BlockPos> getComparator() {
        return GadgetUtils.POSITION_COMPARATOR;
    }

    private boolean isXOverflowed() {
        return this.nextPosX > this.maxX;
    }

    private boolean isYOverflowed() {
        return this.nextPosY > this.maxY;
    }

    private boolean isZOverflowed() {
        return this.nextPosZ > this.maxZ;
    }

    private void resetPos() {
        this.nextPosX = this.minX;
        this.nextPosY = this.minY;
        this.nextPosZ = this.minZ;
    }
}

