/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.building.placement;

import com.direwolf20.buildinggadgets.common.building.IPlacementSequence;
import com.direwolf20.buildinggadgets.common.building.Region;
import com.direwolf20.buildinggadgets.common.tools.VectorTools;
import com.google.common.collect.AbstractIterator;
import java.util.Iterator;
import javax.annotation.Nonnull;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public final class ExclusiveAxisChasing
implements IPlacementSequence {
    private final BlockPos source;
    private final EnumFacing offsetDirection;
    private final int maxProgression;

    public static ExclusiveAxisChasing create(BlockPos source, BlockPos target, EnumFacing.Axis axis, int maxProgression) {
        int difference = VectorTools.getAxisValue(target, axis) - VectorTools.getAxisValue(source, axis);
        if (difference < 0) {
            return ExclusiveAxisChasing.create(source, target, EnumFacing.func_181076_a((EnumFacing.AxisDirection)EnumFacing.AxisDirection.NEGATIVE, (EnumFacing.Axis)axis), maxProgression);
        }
        return ExclusiveAxisChasing.create(source, target, EnumFacing.func_181076_a((EnumFacing.AxisDirection)EnumFacing.AxisDirection.POSITIVE, (EnumFacing.Axis)axis), maxProgression);
    }

    public static ExclusiveAxisChasing create(BlockPos source, BlockPos target, EnumFacing offsetDirection, int maxProgression) {
        EnumFacing.Axis axis = offsetDirection.func_176740_k();
        int difference = VectorTools.getAxisValue(target, axis) - VectorTools.getAxisValue(source, axis);
        maxProgression = Math.min(Math.abs(difference), maxProgression);
        return new ExclusiveAxisChasing(source, offsetDirection, maxProgression);
    }

    public ExclusiveAxisChasing(BlockPos source, EnumFacing offsetDirection, int maxProgression) {
        this.source = source;
        this.offsetDirection = offsetDirection;
        this.maxProgression = maxProgression;
    }

    @Override
    public Region getBoundingBox() {
        return null;
    }

    @Override
    public boolean mayContain(int x, int y, int z) {
        int sourceValue;
        EnumFacing.Axis axis = this.offsetDirection.func_176740_k();
        int value = VectorTools.getAxisValue(x, y, z, axis);
        int difference = Math.abs(value - (sourceValue = VectorTools.getAxisValue(this.source, axis)));
        return difference > 0 && difference < this.maxProgression;
    }

    @Override
    public IPlacementSequence copy() {
        return new ExclusiveAxisChasing(this.source, this.offsetDirection, this.maxProgression);
    }

    @Override
    @Nonnull
    public Iterator<BlockPos> iterator() {
        return new AbstractIterator<BlockPos>(){
            private int progression = 0;

            protected BlockPos computeNext() {
                if (this.progression >= ExclusiveAxisChasing.this.maxProgression) {
                    return (BlockPos)this.endOfData();
                }
                return ExclusiveAxisChasing.this.source.func_177967_a(ExclusiveAxisChasing.this.offsetDirection, this.progression++);
            }
        };
    }
}

