/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tools;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;

public class WorldSave
extends WorldSavedData {
    private final String TAG_NAME;
    private Map<String, NBTTagCompound> tagMap = new HashMap<String, NBTTagCompound>();

    public WorldSave(String name, String tagName) {
        super(name);
        this.TAG_NAME = tagName;
    }

    public void addToMap(String UUID, NBTTagCompound tagCompound) {
        this.tagMap.put(UUID, tagCompound);
        this.func_76185_a();
    }

    public Map<String, NBTTagCompound> getTagMap() {
        return this.tagMap;
    }

    public void setTagMap(Map<String, NBTTagCompound> newMap) {
        this.tagMap = new HashMap<String, NBTTagCompound>(newMap);
    }

    public NBTTagCompound getCompoundFromUUID(String UUID) {
        return this.tagMap.get(UUID);
    }

    public void func_76184_a(NBTTagCompound nbt) {
        if (nbt.func_74764_b(this.TAG_NAME)) {
            NBTTagList tagList = nbt.func_150295_c(this.TAG_NAME, 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound mapTag = tagList.func_150305_b(i);
                String ID = mapTag.func_74779_i("UUID");
                NBTTagCompound tagCompound = mapTag.func_74775_l("tag");
                this.tagMap.put(ID, tagCompound);
            }
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound nbt) {
        NBTTagList tagList = new NBTTagList();
        for (Map.Entry<String, NBTTagCompound> entry : this.tagMap.entrySet()) {
            NBTTagCompound map = new NBTTagCompound();
            map.func_74778_a("UUID", entry.getKey());
            map.func_74782_a("tag", (NBTBase)entry.getValue());
            tagList.func_74742_a((NBTBase)map);
        }
        nbt.func_74782_a(this.TAG_NAME, (NBTBase)tagList);
        return nbt;
    }

    public void markForSaving() {
        this.func_76185_a();
    }

    public static WorldSave getWorldSave(World world) {
        return WorldSave.get(world, WorldSaveBlockMap.class);
    }

    public static WorldSave getTemplateWorldSave(World world) {
        return WorldSave.get(world, WorldSaveTemplate.class);
    }

    public static WorldSave getWorldSaveDestruction(World world) {
        return WorldSave.get(world, WorldSaveDestruction.class);
    }

    @Nonnull
    private static WorldSave get(World world, Class<? extends WorldSave> clazz) {
        String name = "buildinggadgets";
        if (clazz == WorldSaveBlockMap.class) {
            name = name + "_BlockMapData";
        } else if (clazz == WorldSaveTemplate.class) {
            name = name + "_TemplateData";
        } else if (clazz == WorldSaveDestruction.class) {
            name = name + "_DestructionUndo";
        }
        MapStorage storage = world.func_175693_T();
        if (storage == null) {
            throw new IllegalStateException("World#getMapStorage returned null. The following WorldSave failed to save data: " + name);
        }
        WorldSave instance = (WorldSave)storage.func_75742_a(clazz, name);
        if (instance == null) {
            if (clazz == WorldSaveBlockMap.class) {
                instance = new WorldSaveBlockMap(name);
            } else if (clazz == WorldSaveTemplate.class) {
                instance = new WorldSaveTemplate(name);
            } else if (clazz == WorldSaveDestruction.class) {
                instance = new WorldSaveDestruction(name);
            }
            storage.func_75745_a(name, (WorldSavedData)instance);
        }
        return instance;
    }

    public static class WorldSaveDestruction
    extends WorldSave {
        public WorldSaveDestruction(String name) {
            super(name, "destructionundo");
        }
    }

    public static class WorldSaveTemplate
    extends WorldSave {
        public WorldSaveTemplate(String name) {
            super(name, "templatedata");
        }
    }

    public static class WorldSaveBlockMap
    extends WorldSave {
        public WorldSaveBlockMap(String name) {
            super(name, "tagmap");
        }
    }
}

