/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.model.loader.blockstate;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.block.model.Variant;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;

public class CCFinalVariant
extends Variant {
    private final IModelState state;
    private final boolean smooth;
    private final boolean gui3d;
    private final ImmutableMap<String, String> customData;
    private final ImmutableMap<String, String> textures;

    public CCFinalVariant(ResourceLocation model, Optional<IModelState> state, boolean uvLock, boolean smooth, boolean gui3d, int weight, Map<String, String> textures, String textureDomain, Map<String, String> customData) {
        super(model == null ? new ResourceLocation("builtin/missing") : model, state.isPresent() && state.get() instanceof ModelRotation ? (ModelRotation)state.get() : ModelRotation.X0_Y0, uvLock, weight);
        this.state = state.orElse((IModelState)TRSRTransformation.identity());
        this.smooth = smooth;
        this.gui3d = gui3d;
        HashMap<String, String> newTextures = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : textures.entrySet()) {
            String prefixedTexture = entry.getValue();
            if (!entry.getValue().contains(":")) {
                prefixedTexture = textureDomain + ":" + prefixedTexture;
            }
            newTextures.put(entry.getKey(), prefixedTexture);
        }
        this.textures = ImmutableMap.copyOf(newTextures);
        this.customData = ImmutableMap.copyOf(customData);
    }

    public IModel process(IModel base) {
        boolean hasBase;
        boolean bl = hasBase = base != ModelLoaderRegistry.getMissingModel();
        if (hasBase) {
            base = base.retexture(this.textures).smoothLighting(this.smooth).gui3d(this.gui3d).uvlock(this.func_188049_c()).process(this.customData);
        }
        return base;
    }

    public IModelState getState() {
        return this.state;
    }
}

