/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import vazkii.arl.util.ProxyRegistry;

public class RecipeProcessor {
    private static Function<ItemStack, Integer> compositeFunction = stack -> 0;
    private static final List<Consumer<IRecipe>> recipeConsumers = new ArrayList<Consumer<IRecipe>>();

    public static void addReplacementFunction(Function<ItemStack, Integer> f) {
        Function<ItemStack, Integer> curr = compositeFunction;
        compositeFunction = stack -> {
            int res = (Integer)f.apply((ItemStack)stack);
            return res == 0 ? (Integer)curr.apply((ItemStack)stack) : Integer.valueOf(res);
        };
    }

    public static void addWoodReplacements(int size, Block ... blocks) {
        for (Block b : blocks) {
            RecipeProcessor.addReplacementFunction(stack -> stack.func_77973_b() == Item.func_150898_a((Block)b) ? size : 0);
        }
    }

    public static void addWoodReplacements(Block ... blocks) {
        RecipeProcessor.addWoodReplacements(1, blocks);
    }

    public static void addConsumer(Consumer<IRecipe> consumer) {
        recipeConsumers.add(consumer);
    }

    public static void runConsumers() {
        ArrayList recipeList = new ArrayList(CraftingManager.field_193380_a.func_148742_b());
        for (ResourceLocation res : recipeList) {
            IRecipe recipe = (IRecipe)CraftingManager.field_193380_a.func_82594_a((Object)res);
            for (Consumer<IRecipe> consumer : recipeConsumers) {
                consumer.accept(recipe);
            }
        }
    }

    private static void executeWoodReplacementsOverRecipe(IRecipe recipe) {
        int finalSize;
        ItemStack out = recipe.func_77571_b();
        if (recipe instanceof ShapedRecipes && !out.func_190926_b() && (finalSize = compositeFunction.apply(out).intValue()) > 0) {
            ShapedRecipes shaped = (ShapedRecipes)recipe;
            NonNullList ingredients = shaped.field_77574_d;
            for (int i = 0; i < ingredients.size(); ++i) {
                Ingredient ingredient = (Ingredient)ingredients.get(i);
                if (!ingredient.apply(ProxyRegistry.newStack((Block)Blocks.field_150344_f))) continue;
                ingredients.set(i, (Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ProxyRegistry.newStack((Block)Blocks.field_150344_f, (int)1, (int)0)}));
            }
            out.func_190920_e(finalSize);
        }
    }

    static {
        RecipeProcessor.addConsumer(RecipeProcessor::executeWoodReplacementsOverRecipe);
    }
}

