/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.biomes;

import java.util.Random;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenShrub;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import twilightforest.TFFeature;
import twilightforest.TwilightForestMod;
import twilightforest.biomes.TFBiomeBase;
import twilightforest.enums.FireJetVariant;
import twilightforest.world.feature.TFGenFireJet;
import twilightforest.world.feature.TFGenVines;

public class TFBiomeFireSwamp
extends TFBiomeBase {
    public TFBiomeFireSwamp(Biome.BiomeProperties props) {
        super(props);
        this.getTFBiomeDecorator().setDeadBushPerChunk(2);
        this.getTFBiomeDecorator().setMushroomsPerChunk(8);
        this.getTFBiomeDecorator().setReedsPerChunk(4);
        this.getTFBiomeDecorator().setClayPerChunk(1);
        this.getTFBiomeDecorator().setTreesPerChunk(3);
        this.getTFBiomeDecorator().setWaterlilyPerChunk(6);
        this.getTFBiomeDecorator().hasCanopy = false;
        this.getTFBiomeDecorator().lavaPoolChance = 0.125f;
        this.getTFBiomeDecorator().mangrovesPerChunk = 3;
    }

    @Override
    public WorldGenAbstractTree func_150567_a(Random random) {
        if (random.nextInt(3) == 0) {
            return new WorldGenShrub(Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.JUNGLE), Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.OAK).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)));
        }
        return field_76763_Q;
    }

    public void func_180624_a(World world, Random rand, BlockPos pos) {
        super.func_180624_a(world, rand, pos);
        TFFeature nearFeature = TFFeature.getNearestFeature(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4, world);
        if (nearFeature.areChunkDecorationsEnabled) {
            int rz;
            int ry;
            int rx;
            BlockPos.MutableBlockPos mutPos = new BlockPos.MutableBlockPos();
            TFGenVines vines = new TFGenVines();
            for (int i = 0; i < 20; ++i) {
                rx = pos.func_177958_n() + rand.nextInt(16) + 8;
                ry = 159;
                rz = pos.func_177952_p() + rand.nextInt(16) + 8;
                vines.func_180709_b(world, rand, (BlockPos)mutPos.func_181079_c(rx, ry, rz));
            }
            TFGenFireJet genSmoker = new TFGenFireJet(FireJetVariant.SMOKER);
            if (rand.nextInt(4) == 0) {
                rx = pos.func_177958_n() + rand.nextInt(14) + 8;
                ry = 31;
                rz = pos.func_177952_p() + rand.nextInt(14) + 8;
                genSmoker.func_180709_b(world, rand, (BlockPos)mutPos.func_181079_c(rx, ry, rz));
            }
            TFGenFireJet genFireJet = new TFGenFireJet(FireJetVariant.JET_IDLE);
            for (int i = 0; i < 1; ++i) {
                int rx2 = pos.func_177958_n() + rand.nextInt(14) + 8;
                int ry2 = 31;
                int rz2 = pos.func_177952_p() + rand.nextInt(14) + 8;
                genFireJet.func_180709_b(world, rand, (BlockPos)mutPos.func_181079_c(rx2, ry2, rz2));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180627_b(BlockPos pos) {
        return 5713443;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180625_c(BlockPos pos) {
        return 6563343;
    }

    @Override
    protected ResourceLocation[] getRequiredAdvancements() {
        return new ResourceLocation[]{TwilightForestMod.prefix("progress_labyrinth")};
    }

    @Override
    public void enforceProgression(EntityPlayer player, World world) {
        if (!world.field_72995_K && player.field_70173_aa % 60 == 0) {
            player.func_70015_d(8);
        }
        this.trySpawnHintMonster(player, world);
    }

    @Override
    protected TFFeature getContainedFeature() {
        return TFFeature.HYDRA_LAIR;
    }
}

