/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.tiles;

import buildcraft.api.statements.ITriggerExternal;
import forestry.api.core.IErrorLogic;
import forestry.core.errors.EnumErrorCode;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.StandardTank;
import forestry.core.fluids.TankManager;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.inventory.watchers.ISlotPickupWatcher;
import forestry.core.network.PacketBufferForestry;
import forestry.core.render.TankRenderInfo;
import forestry.core.tiles.ILiquidTankTile;
import forestry.core.tiles.TilePowered;
import forestry.factory.gui.ContainerBottler;
import forestry.factory.gui.GuiBottler;
import forestry.factory.inventory.InventoryBottler;
import forestry.factory.recipes.BottlerRecipe;
import forestry.factory.triggers.FactoryTriggers;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileBottler
extends TilePowered
implements ISidedInventory,
ILiquidTankTile,
ISlotPickupWatcher {
    private static final int TICKS_PER_RECIPE_TIME = 5;
    private static final int ENERGY_PER_RECIPE_TIME = 1000;
    private final StandardTank resourceTank;
    private final TankManager tankManager;
    private final EnumMap<EnumFacing, Boolean> canDump;
    private boolean dumpingFluid = false;
    @Nullable
    private BottlerRecipe currentRecipe;
    @SideOnly(value=Side.CLIENT)
    public boolean isFillRecipe;

    public TileBottler() {
        super(1100, 4000);
        this.setInternalInventory(new InventoryBottler(this));
        this.resourceTank = new StandardTank(10000);
        this.tankManager = new TankManager(this, this.resourceTank);
        this.canDump = new EnumMap(EnumFacing.class);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        nbttagcompound = super.func_189515_b(nbttagcompound);
        this.tankManager.writeToNBT(nbttagcompound);
        return nbttagcompound;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.tankManager.readFromNBT(nbttagcompound);
        this.checkEmptyRecipe();
        this.checkFillRecipe();
    }

    @Override
    public void writeData(PacketBufferForestry data) {
        super.writeData(data);
        this.tankManager.writeData(data);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void readData(PacketBufferForestry data) throws IOException {
        super.readData(data);
        this.tankManager.readData(data);
    }

    @Override
    public void updateServerSide() {
        super.updateServerSide();
        if (this.updateOnInterval(20)) {
            ItemStack inputStack;
            ItemStack leftProcessingStack = this.func_70301_a(2);
            ItemStack rightProcessingStack = this.func_70301_a(3);
            if (leftProcessingStack.func_190926_b() && !(inputStack = this.func_70301_a(0)).func_190926_b()) {
                leftProcessingStack = this.func_70298_a(0, 1);
                this.func_70299_a(2, leftProcessingStack);
            }
            if (rightProcessingStack.func_190926_b() && !(inputStack = this.func_70301_a(1)).func_190926_b()) {
                rightProcessingStack = this.func_70298_a(1, 1);
                this.func_70299_a(3, rightProcessingStack);
            }
        }
        if (this.canDump() && (this.dumpingFluid || this.updateOnInterval(20))) {
            this.dumpingFluid = this.dumpFluid();
        }
    }

    private boolean canDump() {
        FluidStack fluid = this.tankManager.getFluid(0);
        if (fluid != null) {
            if (this.canDump.isEmpty()) {
                for (EnumFacing facing : EnumFacing.field_82609_l) {
                    this.canDump.put(facing, FluidHelper.canAcceptFluid(this.field_145850_b, this.field_174879_c.func_177972_a(facing), facing.func_176734_d(), fluid));
                }
            }
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                if (!this.canDump.get(facing).booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean dumpFluid() {
        if (!this.resourceTank.isEmpty()) {
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                IFluidHandler fluidDestination;
                if (!this.canDump.get(facing).booleanValue() || (fluidDestination = FluidUtil.getFluidHandler((World)this.field_145850_b, (BlockPos)this.field_174879_c.func_177972_a(facing), (EnumFacing)facing.func_176734_d())) == null || FluidUtil.tryFluidTransfer((IFluidHandler)fluidDestination, (IFluidHandler)this.tankManager, (int)50, (boolean)true) == null) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean workCycle() {
        FluidHelper.FillStatus status;
        if (this.currentRecipe != null) {
            status = this.currentRecipe.fillRecipe ? FluidHelper.fillContainers(this.tankManager, (IInventory)this, 3, 5, this.currentRecipe.fluid.getFluid(), true) : FluidHelper.drainContainers(this.tankManager, (IInventory)this, 2, 4, true);
        } else {
            return true;
        }
        if (status == FluidHelper.FillStatus.SUCCESS) {
            this.currentRecipe = null;
            return true;
        }
        return false;
    }

    @Override
    public void onNeighborTileChange(World world, BlockPos pos, BlockPos neighbor) {
        super.onNeighborTileChange(world, pos, neighbor);
        this.canDump.clear();
    }

    private void checkFillRecipe() {
        ItemStack emptyCan = this.func_70301_a(3);
        if (!emptyCan.func_190926_b()) {
            FluidStack resource = this.resourceTank.getFluid();
            if (resource == null) {
                return;
            }
            if (this.currentRecipe == null || !this.currentRecipe.matchEmpty(emptyCan, resource)) {
                this.currentRecipe = BottlerRecipe.createFillingRecipe(resource.getFluid(), emptyCan);
                if (this.currentRecipe != null) {
                    float viscosityMultiplier = (float)resource.getFluid().getViscosity(resource) / 1000.0f;
                    viscosityMultiplier = (viscosityMultiplier - 1.0f) / 20.0f + 1.0f;
                    int fillAmount = Math.min(this.currentRecipe.fluid.amount, resource.amount);
                    float fillTime = (float)fillAmount / 1000.0f;
                    this.setTicksPerWorkCycle(Math.round((fillTime *= viscosityMultiplier) * 5.0f));
                    this.setEnergyPerWorkCycle(Math.round(fillTime * 1000.0f));
                }
            }
        }
    }

    private void checkEmptyRecipe() {
        ItemStack filledCan = this.func_70301_a(2);
        if (!(filledCan.func_190926_b() || this.currentRecipe != null && (this.currentRecipe.matchFilled(filledCan) || this.currentRecipe.fillRecipe))) {
            this.currentRecipe = BottlerRecipe.createEmptyingRecipe(filledCan);
            if (this.currentRecipe != null) {
                FluidStack resource = this.currentRecipe.fluid;
                float viscosityMultiplier = (float)resource.getFluid().getViscosity(resource) / 1000.0f;
                viscosityMultiplier = (viscosityMultiplier - 1.0f) / 20.0f + 1.0f;
                int fillAmount = Math.min(this.currentRecipe.fluid.amount, resource.amount);
                float fillTime = (float)fillAmount / 1000.0f;
                this.setTicksPerWorkCycle(Math.round((fillTime *= viscosityMultiplier) * 5.0f));
                this.setEnergyPerWorkCycle(0);
            }
        }
    }

    @Override
    public void onTake(int slotIndex, EntityPlayer player) {
        if (slotIndex == 2) {
            if (this.currentRecipe != null && !this.currentRecipe.fillRecipe) {
                this.currentRecipe = null;
                this.setTicksPerWorkCycle(0);
            }
        } else if (slotIndex == 3 && this.currentRecipe != null && this.currentRecipe.fillRecipe) {
            this.currentRecipe = null;
            this.setTicksPerWorkCycle(0);
        }
    }

    @Override
    public void writeGuiData(PacketBufferForestry data) {
        super.writeGuiData(data);
        if (this.currentRecipe == null) {
            data.writeBoolean(false);
        } else {
            data.writeBoolean(this.currentRecipe.fillRecipe);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void readGuiData(PacketBufferForestry data) throws IOException {
        super.readGuiData(data);
        this.isFillRecipe = data.readBoolean();
    }

    @Override
    public boolean hasResourcesMin(float percentage) {
        IInventoryAdapter inventory = this.getInternalInventory();
        ItemStack emptyCan = inventory.func_70301_a(3);
        if (emptyCan.func_190926_b()) {
            return false;
        }
        return (float)emptyCan.func_190916_E() / (float)emptyCan.func_77976_d() > percentage;
    }

    @Override
    public boolean hasWork() {
        IFluidTankProperties properties;
        IErrorLogic errorLogic = this.getErrorLogic();
        errorLogic.clearErrors();
        this.checkEmptyRecipe();
        FluidHelper.FillStatus emptyStatus = this.currentRecipe != null ? ((properties = this.tankManager.getTankProperties()[0]) != null ? FluidHelper.drainContainers(this.tankManager, (IInventory)this, 2, 4, false) : FluidHelper.FillStatus.SUCCESS) : null;
        if (emptyStatus == null || emptyStatus != FluidHelper.FillStatus.SUCCESS) {
            this.checkFillRecipe();
            if (this.currentRecipe == null) {
                return false;
            }
        } else {
            return true;
        }
        FluidHelper.FillStatus fillStatus = FluidHelper.fillContainers(this.tankManager, (IInventory)this, 3, 5, this.currentRecipe.fluid.getFluid(), false);
        if (fillStatus == FluidHelper.FillStatus.SUCCESS) {
            return true;
        }
        errorLogic.setCondition(fillStatus == FluidHelper.FillStatus.NO_FLUID, EnumErrorCode.NO_RESOURCE_LIQUID);
        errorLogic.setCondition(fillStatus == FluidHelper.FillStatus.NO_SPACE, EnumErrorCode.NO_SPACE_INVENTORY);
        errorLogic.setCondition(emptyStatus == FluidHelper.FillStatus.NO_SPACE_FLUID, EnumErrorCode.NO_SPACE_TANK);
        if (emptyStatus == FluidHelper.FillStatus.INVALID_INPUT || fillStatus == FluidHelper.FillStatus.INVALID_INPUT || errorLogic.hasErrors()) {
            this.currentRecipe = null;
            return false;
        }
        return true;
    }

    @Override
    public TankRenderInfo getResourceTankInfo() {
        return new TankRenderInfo((IFluidTank)this.resourceTank);
    }

    @Override
    public TankManager getTankManager() {
        return this.tankManager;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.tankManager);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    @Optional.Method(modid="buildcraftlib")
    public void addExternalTriggers(Collection<ITriggerExternal> triggers, @Nonnull EnumFacing side, TileEntity tile) {
        super.addExternalTriggers(triggers, side, tile);
        triggers.add(FactoryTriggers.lowResource25);
        triggers.add(FactoryTriggers.lowResource10);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiContainer getGui(EntityPlayer player, int data) {
        return new GuiBottler(player.field_71071_by, this);
    }

    @Override
    public Container getContainer(EntityPlayer player, int data) {
        return new ContainerBottler(player.field_71071_by, this);
    }
}

