/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.blocks;

import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.lepidopterology.IAlleleButterflyCocoon;
import forestry.core.render.ForestryStateMapper;
import forestry.lepidopterology.blocks.BlockCocoon;
import forestry.lepidopterology.blocks.BlockSolidCocoon;
import forestry.lepidopterology.genetics.alleles.AlleleButterflyCocoon;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class CocoonStateMapper
extends ForestryStateMapper {
    public Map<IBlockState, ModelResourceLocation> func_178130_a(Block block) {
        if (block instanceof BlockCocoon || block instanceof BlockSolidCocoon) {
            for (IAllele allele : AlleleManager.alleleRegistry.getRegisteredAlleles().values()) {
                if (!(allele instanceof IAlleleButterflyCocoon)) continue;
                for (int age = 0; age < 3; ++age) {
                    IAlleleButterflyCocoon cocoon = (IAlleleButterflyCocoon)allele;
                    String resourcePath = "forestry:cocoons/cocoon_" + cocoon.getCocoonName();
                    IBlockState state = block.func_176223_P().func_177226_a((IProperty)AlleleButterflyCocoon.COCOON, (Comparable)cocoon).func_177226_a((IProperty)AlleleButterflyCocoon.AGE, (Comparable)Integer.valueOf(age));
                    String propertyString = "age=" + age;
                    this.mapStateModelLocations.put(state, new ModelResourceLocation(resourcePath, propertyString));
                }
            }
        }
        return this.mapStateModelLocations;
    }
}

