/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.core.handler;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import vazkii.arl.network.NetworkHandler;
import vazkii.psi.common.core.handler.PlayerDataHandler;
import vazkii.psi.common.network.message.MessageLoopcastSync;

@Mod.EventBusSubscriber(modid="psi")
public class LoopcastTrackingHandler {
    @SubscribeEvent
    public static void onPlayerStartTracking(PlayerEvent.StartTracking event) {
        if (event.getTarget() instanceof EntityPlayer) {
            LoopcastTrackingHandler.syncDataFor((EntityPlayer)event.getTarget(), (EntityPlayerMP)event.getEntityPlayer());
        }
    }

    @SubscribeEvent
    public static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        LoopcastTrackingHandler.syncDataFor(event.player, (EntityPlayerMP)event.player);
    }

    @SubscribeEvent
    public static void onPlayerLogIn(PlayerEvent.PlayerLoggedInEvent event) {
        LoopcastTrackingHandler.syncDataFor(event.player, (EntityPlayerMP)event.player);
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        LoopcastTrackingHandler.syncDataFor(event.player, (EntityPlayerMP)event.player);
    }

    public static void syncDataFor(EntityPlayer player, EntityPlayerMP receiver) {
        PlayerDataHandler.PlayerData data = PlayerDataHandler.get(player);
        NetworkHandler.INSTANCE.sendTo((IMessage)new MessageLoopcastSync(player.func_145782_y(), data.loopcasting, data.loopcastHand), receiver);
    }

    public static void syncForTrackers(EntityPlayerMP player) {
        LoopcastTrackingHandler.syncDataFor((EntityPlayer)player, player);
        for (EntityPlayer tracker : player.func_71121_q().func_73039_n().getTrackingPlayers((Entity)player)) {
            if (!(tracker instanceof EntityPlayerMP)) continue;
            LoopcastTrackingHandler.syncDataFor((EntityPlayer)player, (EntityPlayerMP)tracker);
        }
    }
}

