/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.other;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.psi.api.internal.TooltipHelper;
import vazkii.psi.api.spell.EnumPieceType;
import vazkii.psi.api.spell.IRedirector;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellPiece;
import vazkii.psi.api.spell.param.ParamAny;

public class PieceConnector
extends SpellPiece
implements IRedirector {
    private static final ResourceLocation lines = new ResourceLocation("psi:textures/spell/connector_lines.png");
    public SpellParam target;

    public PieceConnector(Spell spell) {
        super(spell);
    }

    @Override
    public String getSortingName() {
        return "00000000000";
    }

    @Override
    public String getEvaluationTypeString() {
        return TooltipHelper.local("psi.datatype.Any");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawAdditional() {
        this.drawSide((SpellParam.Side)((Object)this.paramSides.get(this.target)));
        if (this.isInGrid) {
            block0: for (SpellParam.Side side : (SpellParam.Side[])SpellParam.Side.class.getEnumConstants()) {
                SpellPiece piece;
                if (!side.isEnabled() || (piece = this.spell.grid.getPieceAtSideSafely(this.x, this.y, side)) == null) continue;
                for (SpellParam param : piece.paramSides.keySet()) {
                    SpellParam.Side paramSide = piece.paramSides.get(param);
                    if (paramSide.getOpposite() != side) continue;
                    this.drawSide(side);
                    continue block0;
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void drawSide(SpellParam.Side side) {
        if (side.isEnabled()) {
            Minecraft mc = Minecraft.func_71410_x();
            mc.field_71446_o.func_110577_a(lines);
            double minU = 0.0;
            double minV = 0.0;
            switch (side) {
                case LEFT: {
                    minU = 0.5;
                    break;
                }
                case RIGHT: {
                    break;
                }
                case TOP: {
                    minV = 0.5;
                    break;
                }
                case BOTTOM: {
                    minU = 0.5;
                    minV = 0.5;
                    break;
                }
            }
            double maxU = minU + 0.5;
            double maxV = minV + 0.5;
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
            wr.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            wr.func_181662_b(0.0, 16.0, 0.0).func_187315_a(minU, maxV).func_181675_d();
            wr.func_181662_b(16.0, 16.0, 0.0).func_187315_a(maxU, maxV).func_181675_d();
            wr.func_181662_b(16.0, 0.0, 0.0).func_187315_a(maxU, minV).func_181675_d();
            wr.func_181662_b(0.0, 0.0, 0.0).func_187315_a(minU, minV).func_181675_d();
            Tessellator.func_178181_a().func_78381_a();
        }
    }

    @Override
    public void getShownPieces(List<SpellPiece> pieces) {
        for (SpellParam.Side side : (SpellParam.Side[])SpellParam.Side.class.getEnumConstants()) {
            if (!side.isEnabled()) continue;
            PieceConnector piece = (PieceConnector)this.copy();
            piece.paramSides.put(piece.target, side);
            pieces.add(piece);
        }
    }

    @Override
    public void initParams() {
        this.target = new ParamAny("psi.spellparam.target", SpellParam.GRAY, false);
        this.addParam(this.target);
    }

    @Override
    public EnumPieceType getPieceType() {
        return EnumPieceType.CONNECTOR;
    }

    @Override
    public SpellParam.Side getRedirectionSide() {
        return (SpellParam.Side)((Object)this.paramSides.get(this.target));
    }

    @Override
    public Class<?> getEvaluationType() {
        return null;
    }

    @Override
    public Object evaluate() {
        return null;
    }

    @Override
    public Object execute(SpellContext context) {
        return null;
    }
}

