/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.trick;

import net.minecraft.item.ItemStack;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.cad.ICAD;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamNumber;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceTrick;

public class PieceTrickSaveVector
extends PieceTrick {
    public static final String KEY_SLOT_LOCKED = "psi:SlotLocked";
    SpellParam number;
    SpellParam target;

    public PieceTrickSaveVector(Spell spell) {
        super(spell);
    }

    @Override
    public void initParams() {
        this.number = new ParamNumber("psi.spellparam.number", SpellParam.BLUE, false, true);
        this.addParam(this.number);
        this.target = new ParamVector("psi.spellparam.target", SpellParam.RED, false, false);
        this.addParam(this.target);
    }

    @Override
    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        meta.addStat(EnumSpellStat.COMPLEXITY, 1);
        Double numberVal = (Double)this.getParamEvaluation(this.number);
        if (numberVal == null || numberVal <= 0.0 || numberVal != (double)numberVal.intValue()) {
            throw new SpellCompilationException("psi.spellerror.nonpositiveinteger", this.x, this.y);
        }
        meta.addStat(EnumSpellStat.POTENCY, numberVal.intValue() * 8);
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        Double numberVal = (Double)this.getParamValue(context, this.number);
        Vector3 targetVal = (Vector3)this.getParamValue(context, this.target);
        int n = numberVal.intValue() - 1;
        if (context.customData.containsKey(KEY_SLOT_LOCKED + n)) {
            return null;
        }
        ItemStack cadStack = PsiAPI.getPlayerCAD(context.caster);
        if (cadStack == null || !(cadStack.func_77973_b() instanceof ICAD)) {
            throw new SpellRuntimeException("psi.spellerror.nocad");
        }
        ICAD cad = (ICAD)cadStack.func_77973_b();
        cad.setStoredVector(cadStack, n, targetVal);
        context.customData.put(KEY_SLOT_LOCKED + n, 0);
        return null;
    }
}

