/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.handler.magicavoxel;

import com.google.common.primitives.Ints;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import lumien.randomthings.RandomThings;
import lumien.randomthings.handler.magicavoxel.MagicaVoxelModel;
import lumien.randomthings.handler.magicavoxel.Palette;
import org.apache.logging.log4j.Level;

public class MagicaVoxelLoader {
    public static MagicaVoxelModel getModel(InputStream modelInputStream, InputStream paletteInputStream) throws Exception {
        Palette palette = MagicaVoxelLoader.getPalette(paletteInputStream);
        block6: for (int i = 0; i < 4; ++i) {
            int b = modelInputStream.read();
            switch (i) {
                case 0: {
                    if (b == 86) continue block6;
                    modelInputStream.close();
                    throw new Exception("Invalid VOX Header");
                }
                case 1: {
                    if (b == 79) continue block6;
                    modelInputStream.close();
                    throw new Exception("Invalid VOX Header");
                }
                case 2: {
                    if (b == 88) continue block6;
                    modelInputStream.close();
                    throw new Exception("Invalid VOX Header");
                }
                case 3: {
                    if (b == 32) continue block6;
                    modelInputStream.close();
                    throw new Exception("Invalid VOX Header");
                }
            }
        }
        byte[] versionBytes = new byte[4];
        modelInputStream.read(versionBytes);
        int voxVersion = Ints.fromBytes((byte)versionBytes[3], (byte)versionBytes[2], (byte)versionBytes[1], (byte)versionBytes[0]);
        RandomThings.instance.logger.log(Level.DEBUG, "VOX File Version: " + voxVersion);
        MagicaVoxelModel model = new MagicaVoxelModel(palette);
        byte[] chunkIDBytes = new byte[4];
        byte[] contentSizeBytes = new byte[4];
        byte[] childrenSizeBytes = new byte[4];
        while (modelInputStream.read(chunkIDBytes) > 0) {
            int z;
            int y;
            int x;
            String chunkID = "" + (char)chunkIDBytes[0] + (char)chunkIDBytes[1] + (char)chunkIDBytes[2] + (char)chunkIDBytes[3];
            RandomThings.instance.logger.log(Level.DEBUG, " - CHUNK: " + chunkID);
            modelInputStream.read(contentSizeBytes);
            modelInputStream.read(childrenSizeBytes);
            int contentSize = Ints.fromBytes((byte)contentSizeBytes[3], (byte)contentSizeBytes[2], (byte)contentSizeBytes[1], (byte)contentSizeBytes[0]);
            int childrenSize = Ints.fromBytes((byte)childrenSizeBytes[3], (byte)childrenSizeBytes[2], (byte)childrenSizeBytes[1], (byte)childrenSizeBytes[0]);
            if (contentSize <= 0) continue;
            byte[] chunkContent = new byte[contentSize];
            modelInputStream.read(chunkContent);
            ByteArrayInputStream contentStream = new ByteArrayInputStream(chunkContent);
            if (chunkID.equals("SIZE")) {
                byte[] bX = new byte[4];
                byte[] bY = new byte[4];
                byte[] bZ = new byte[4];
                contentStream.read(bX);
                contentStream.read(bY);
                contentStream.read(bZ);
                x = Ints.fromBytes((byte)bX[3], (byte)bX[2], (byte)bX[1], (byte)bX[0]);
                y = Ints.fromBytes((byte)bY[3], (byte)bY[2], (byte)bY[1], (byte)bY[0]);
                z = Ints.fromBytes((byte)bZ[3], (byte)bZ[2], (byte)bZ[1], (byte)bZ[0]);
                model.setSize(x, z, y);
                RandomThings.instance.logger.log(Level.DEBUG, " - Set Size: " + x + ":" + z + ":" + y);
                continue;
            }
            if (!chunkID.equals("XYZI")) continue;
            byte[] numVoxelsBytes = new byte[4];
            contentStream.read(numVoxelsBytes);
            int numVoxels = Ints.fromBytes((byte)numVoxelsBytes[3], (byte)numVoxelsBytes[2], (byte)numVoxelsBytes[1], (byte)numVoxelsBytes[0]);
            RandomThings.instance.logger.log(Level.DEBUG, " - Added " + numVoxels + " Voxels");
            for (int i = 0; i < numVoxels; ++i) {
                x = contentStream.read();
                y = contentStream.read();
                z = contentStream.read();
                int colorIndex = contentStream.read();
                model.addVoxel(x, z, y, colorIndex);
            }
        }
        modelInputStream.close();
        model.build();
        return model;
    }

    public static MagicaVoxelModel getModel(File modelFile, File paletteFile) throws Exception {
        return MagicaVoxelLoader.getModel(new FileInputStream(modelFile), new FileInputStream(paletteFile));
    }

    public static Palette getPalette(InputStream paletteInputStream) throws IOException {
        Color[] colorTable = new Color[256];
        for (int i = 0; i < colorTable.length; ++i) {
            colorTable[i] = new Color(paletteInputStream.read(), paletteInputStream.read(), paletteInputStream.read());
        }
        paletteInputStream.close();
        return new Palette(colorTable);
    }
}

