/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.tileentity;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.WeakHashMap;
import lumien.randomthings.item.ItemSoundPattern;
import lumien.randomthings.item.ModItems;
import lumien.randomthings.tileentity.TileEntityBase;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileEntitySoundDampener
extends TileEntityBase {
    public static Set<TileEntitySoundDampener> dampeners = Collections.newSetFromMap(new WeakHashMap());
    HashSet<ResourceLocation> mutedSounds = new HashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TileEntitySoundDampener() {
        this.setItemHandler(9);
        this.setInventoryChangeListener(() -> {
            if (!this.field_145850_b.field_72995_K) {
                this.mutedSounds.clear();
                for (int i = 0; i < this.getItemHandler().getSlots(); ++i) {
                    ResourceLocation sound;
                    ItemStack is = this.getItemHandler().getStackInSlot(i);
                    if (is.func_190926_b() || is.func_77973_b() != ModItems.soundPattern || (sound = ItemSoundPattern.getSoundLocation(is)) == null) continue;
                    this.mutedSounds.add(sound);
                }
                this.syncTE();
            }
        });
        Set<TileEntitySoundDampener> set = dampeners;
        synchronized (set) {
            dampeners.add(this);
        }
    }

    public HashSet<ResourceLocation> getMutedSounds() {
        return this.mutedSounds;
    }

    public void func_70296_d() {
        super.func_70296_d();
    }

    @Override
    public void writeDataToNBT(NBTTagCompound compound, boolean sync) {
        NBTTagList soundList = new NBTTagList();
        for (ResourceLocation rl : this.mutedSounds) {
            soundList.func_74742_a((NBTBase)new NBTTagString(rl.toString()));
        }
        compound.func_74782_a("mutedSounds", (NBTBase)soundList);
    }

    @Override
    public void readDataFromNBT(NBTTagCompound compound, boolean sync) {
        NBTTagList soundList = compound.func_150295_c("mutedSounds", 8);
        this.mutedSounds = new HashSet();
        for (int i = 0; i < soundList.func_74745_c(); ++i) {
            String sound = soundList.func_150307_f(i);
            this.mutedSounds.add(new ResourceLocation(sound));
        }
    }

    @Override
    public void breakBlock(World worldIn, BlockPos pos, IBlockState state) {
        super.breakBlock(worldIn, pos, state);
        this.func_145843_s();
    }

    public void onChunkUnload() {
        this.func_145843_s();
    }
}

