/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.audio.storage;

import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.charset.api.tape.IDataStorage;
import pl.asie.charset.module.audio.storage.CharsetAudioStorage;

public class ItemQuartzDisc
extends Item {
    public static final int DEFAULT_SAMPLE_RATE = 48000;
    private static final int[] SIZES = new int[]{360000, 1080000, 2160000, 3600000};
    private static final float[] ARM_STARTS = new float[]{23.0f, 17.0f, 11.0f, 5.0f};

    public ItemQuartzDisc() {
        this.func_77655_b("charset.quartz_disc");
        this.func_77627_a(true);
        this.func_77625_d(1);
    }

    protected float getArmStartPosition(ItemStack stack) {
        return ARM_STARTS[(stack.func_77960_j() >> 1) % ARM_STARTS.length];
    }

    int getSize(ItemStack stack) {
        int defSize = SIZES[(stack.func_77960_j() >> 1) % SIZES.length];
        return stack.func_77942_o() && stack.func_77978_p().func_150297_b("size", 99) ? stack.func_77978_p().func_74762_e("size") : defSize;
    }

    public String func_77667_c(ItemStack stack) {
        if ((stack.func_77952_i() & 1) == 0) {
            return "item.charset.quartz_disc.blank";
        }
        return "item.charset.quartz_disc";
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (int i = 0; i < SIZES.length; ++i) {
                items.add((Object)new ItemStack((Item)this, 1, i << 1));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag advanced) {
        int size = this.getSize(stack);
        int sizeSec = size / 6000;
        int sizeMin = sizeSec / 60;
        CharsetAudioStorage.addTimeToTooltip(tooltip, sizeMin, sizeSec %= 60);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new CapabilityProvider(stack);
    }

    public static class CapabilityProvider
    implements INBTSerializable<NBTTagCompound>,
    ICapabilityProvider {
        private final ItemStack stack;
        private final IDataStorage dataStorage;

        public CapabilityProvider(ItemStack stack) {
            this.stack = stack;
            this.dataStorage = (IDataStorage)CharsetAudioStorage.DATA_STORAGE.getDefaultInstance();
        }

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return capability == CharsetAudioStorage.DATA_STORAGE;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            if (this.dataStorage != null) {
                if (!this.dataStorage.isInitialized()) {
                    this.dataStorage.initialize(null, 0, CharsetAudioStorage.quartzDisc.getSize(this.stack));
                }
                if (capability == CharsetAudioStorage.DATA_STORAGE) {
                    this.stack.func_77964_b(this.stack.func_77952_i() | 1);
                    return (T)CharsetAudioStorage.DATA_STORAGE.cast((Object)this.dataStorage);
                }
            }
            return null;
        }

        public NBTTagCompound serializeNBT() {
            if (this.dataStorage != null) {
                NBTTagCompound compound = new NBTTagCompound();
                NBTBase data = CharsetAudioStorage.DATA_STORAGE.writeNBT((Object)this.dataStorage, null);
                if (data != null) {
                    compound.func_74782_a("data", data);
                }
                return compound;
            }
            return new NBTTagCompound();
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            if (this.dataStorage != null && nbt.func_74764_b("data")) {
                CharsetAudioStorage.DATA_STORAGE.readNBT((Object)this.dataStorage, null, (NBTBase)nbt.func_74775_l("data"));
            }
        }
    }
}

