/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.audio.storage;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetHandler;
import net.minecraft.network.PacketBuffer;
import pl.asie.charset.lib.network.Packet;
import pl.asie.charset.module.audio.storage.ContainerRecordPlayer;
import pl.asie.charset.module.audio.storage.TileRecordPlayer;

public class PacketDriveData
extends Packet {
    private byte[] data;
    private int totalLength;
    private boolean isLast;

    public PacketDriveData() {
    }

    public PacketDriveData(byte[] data, int totalLength, boolean isLast) {
        this.totalLength = totalLength;
        this.isLast = isLast;
        this.data = data;
    }

    public void readData(INetHandler handler, PacketBuffer buf) {
        this.totalLength = buf.readInt();
        this.isLast = buf.readBoolean();
        short len = buf.readShort();
        if (len > 0) {
            this.data = new byte[len];
            buf.readBytes(this.data);
        }
    }

    public void apply(INetHandler handler) {
        EntityPlayer player = PacketDriveData.getPlayer((INetHandler)handler);
        if (player != null && player.field_71070_bA instanceof ContainerRecordPlayer) {
            TileRecordPlayer owner = ((ContainerRecordPlayer)player.field_71070_bA).owner;
            owner.writeData(this.data, this.isLast, this.totalLength);
        }
    }

    public void writeData(PacketBuffer buf) {
        buf.writeInt(this.totalLength);
        buf.writeBoolean(this.isLast);
        buf.writeShort(this.data.length);
        buf.writeBytes(this.data);
    }

    public boolean isAsynchronous() {
        return false;
    }
}

