/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.common;

import com.google.gson.stream.JsonReader;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.Comparator;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import wanion.lib.common.Util;
import wanion.unidict.Config;
import wanion.unidict.UniDict;
import wanion.unidict.common.Reference;
import wanion.unidict.resource.ResourceHandler;

public final class SpecificEntryItemStackComparator
implements Comparator<ItemStack> {
    public static THashMap<String, SpecificEntryItemStackComparator> entrySpecificComparators = new THashMap();
    private static boolean initialized = false;
    private final TObjectIntMap<String> ownerOfEntry;

    private SpecificEntryItemStackComparator(@Nonnull TObjectIntMap<String> ownerOfEntry) {
        this.ownerOfEntry = ownerOfEntry;
    }

    public static synchronized SpecificEntryItemStackComparator getComparatorFor(@Nonnull String entryName) {
        if (!initialized) {
            SpecificEntryItemStackComparator.init();
        }
        return (SpecificEntryItemStackComparator)entrySpecificComparators.get((Object)entryName);
    }

    public static synchronized boolean hasComparatorForEntry(@Nonnull String entryName) {
        if (!initialized) {
            SpecificEntryItemStackComparator.init();
        }
        return entrySpecificComparators.containsKey((Object)entryName);
    }

    private static void init() {
        File jsonFile = new File("." + Reference.SLASH + "config" + Reference.SLASH + "unidict" + Reference.SLASH + "specificEntrySorting.json");
        try {
            if (!jsonFile.exists() && !jsonFile.createNewFile()) {
                UniDict.getLogger().error("UniDict couldn't create the specificEntrySorting.json file.");
                return;
            }
            try (JsonReader jsonReader = new JsonReader((Reader)new FileReader(jsonFile));){
                jsonReader.beginArray();
                while (jsonReader.hasNext()) {
                    jsonReader.beginObject();
                    if (!jsonReader.nextName().equals("entryName")) {
                        jsonReader.skipValue();
                        jsonReader.endObject();
                        jsonReader.endArray();
                        continue;
                    }
                    String entryName = jsonReader.nextString();
                    if (!jsonReader.nextName().equals("modIdPriorityList")) {
                        jsonReader.skipValue();
                        jsonReader.endObject();
                        jsonReader.endArray();
                        continue;
                    }
                    jsonReader.beginArray();
                    TObjectIntHashMap ownerOfEntry = new TObjectIntHashMap(10, 1.0f, Integer.MAX_VALUE);
                    int i = 0;
                    while (jsonReader.hasNext()) {
                        ownerOfEntry.put((Object)jsonReader.nextString(), i++);
                    }
                    entrySpecificComparators.put((Object)entryName, (Object)new SpecificEntryItemStackComparator((TObjectIntMap<String>)ownerOfEntry));
                    jsonReader.endArray();
                    jsonReader.endObject();
                }
            }
        }
        catch (Throwable e) {
            UniDict.getLogger().error("UniDict couldn't read the specificEntrySorting.json file.");
            e.printStackTrace();
        }
        initialized = true;
    }

    @Override
    public int compare(@Nonnull ItemStack itemStack1, @Nonnull ItemStack itemStack2) {
        int stackIndex2;
        int stackIndex1;
        boolean sameIndexModAndItem;
        String stack1ModName = Util.getModName((ItemStack)itemStack1);
        String stack2ModName = Util.getModName((ItemStack)itemStack2);
        Config config = UniDict.getConfig();
        if (config.keepOneEntry && config.keepOneEntryModBlackSet.contains(stack1ModName)) {
            ResourceHandler.addToKeepOneEntryModBlackSet(itemStack1);
        }
        boolean bl = sameIndexModAndItem = (stackIndex1 = this.getIndex(stack1ModName)) == (stackIndex2 = this.getIndex(stack2ModName)) && stack1ModName.equals(stack2ModName) && itemStack1.func_77973_b() == itemStack2.func_77973_b();
        return !sameIndexModAndItem ? (stackIndex1 < stackIndex2 ? -1 : 0) : (itemStack1.func_77952_i() < itemStack2.func_77952_i() ? -1 : 0);
    }

    private int getIndex(String modName) {
        return this.ownerOfEntry.get((Object)modName);
    }
}

