/*
 * Decompiled with CFR 0.152.
 */
package appeng.fluids.parts;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IFluidStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IItemList;
import appeng.fluids.util.AEFluidStack;
import appeng.me.GridAccessException;
import appeng.me.helpers.IGridProxyable;
import appeng.me.storage.ITickingMonitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class FluidHandlerAdapter
implements IMEInventory<IAEFluidStack>,
IBaseMonitor<IAEFluidStack>,
ITickingMonitor {
    private final Map<IMEMonitorHandlerReceiver<IAEFluidStack>, Object> listeners = new HashMap<IMEMonitorHandlerReceiver<IAEFluidStack>, Object>();
    private IActionSource source;
    private final IFluidHandler fluidHandler;
    private final IGridProxyable proxyable;
    private final InventoryCache cache;

    FluidHandlerAdapter(IFluidHandler fluidHandler, IGridProxyable proxy) {
        this.fluidHandler = fluidHandler;
        this.proxyable = proxy;
        this.cache = new InventoryCache(this.fluidHandler);
    }

    @Override
    public IAEFluidStack injectItems(IAEFluidStack input, Actionable type, IActionSource src) {
        FluidStack fluidStack = input.getFluidStack();
        int wasFillled = this.fluidHandler.fill(fluidStack, type != Actionable.SIMULATE);
        int remaining = fluidStack.amount - wasFillled;
        if (fluidStack.amount == remaining) {
            return input;
        }
        if (type == Actionable.MODULATE) {
            try {
                this.proxyable.getProxy().getTick().alertDevice(this.proxyable.getProxy().getNode());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        fluidStack.amount = remaining;
        return AEFluidStack.fromFluidStack(fluidStack);
    }

    @Override
    public IAEFluidStack extractItems(IAEFluidStack request, Actionable mode, IActionSource src) {
        boolean doDrain;
        FluidStack requestedFluidStack = request.getFluidStack();
        FluidStack gathered = this.fluidHandler.drain(requestedFluidStack, doDrain = mode == Actionable.MODULATE);
        if (gathered == null) {
            return null;
        }
        if (mode == Actionable.MODULATE) {
            try {
                this.proxyable.getProxy().getTick().alertDevice(this.proxyable.getProxy().getNode());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        return AEFluidStack.fromFluidStack(gathered);
    }

    @Override
    public TickRateModulation onTick() {
        List<IAEFluidStack> changes = this.cache.update();
        if (!changes.isEmpty()) {
            this.postDifference(changes);
            return TickRateModulation.URGENT;
        }
        return TickRateModulation.SLOWER;
    }

    @Override
    public IItemList<IAEFluidStack> getAvailableItems(IItemList<IAEFluidStack> out) {
        return this.cache.getAvailableItems(out);
    }

    @Override
    public IStorageChannel<IAEFluidStack> getChannel() {
        return AEApi.instance().storage().getStorageChannel(IFluidStorageChannel.class);
    }

    @Override
    public void setActionSource(IActionSource source) {
        this.source = source;
    }

    @Override
    public void addListener(IMEMonitorHandlerReceiver<IAEFluidStack> l, Object verificationToken) {
        this.listeners.put(l, verificationToken);
    }

    @Override
    public void removeListener(IMEMonitorHandlerReceiver<IAEFluidStack> l) {
        this.listeners.remove(l);
    }

    private void postDifference(Iterable<IAEFluidStack> a) {
        Iterator<Map.Entry<IMEMonitorHandlerReceiver<IAEFluidStack>, Object>> i = this.listeners.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<IMEMonitorHandlerReceiver<IAEFluidStack>, Object> l = i.next();
            IMEMonitorHandlerReceiver<IAEFluidStack> key = l.getKey();
            if (key.isValid(l.getValue())) {
                key.postChange(this, a, this.source);
                continue;
            }
            i.remove();
        }
    }

    private static class InventoryCache {
        private IAEFluidStack[] cachedAeStacks = new IAEFluidStack[0];
        private final IFluidHandler fluidHandler;

        public InventoryCache(IFluidHandler fluidHandler) {
            this.fluidHandler = fluidHandler;
        }

        public List<IAEFluidStack> update() {
            int slot;
            ArrayList<IAEFluidStack> changes = new ArrayList<IAEFluidStack>();
            IFluidTankProperties[] tankProperties = this.fluidHandler.getTankProperties();
            int slots = tankProperties.length;
            if (slots > this.cachedAeStacks.length) {
                this.cachedAeStacks = Arrays.copyOf(this.cachedAeStacks, slots);
            }
            for (slot = 0; slot < slots; ++slot) {
                IAEFluidStack oldAEFS = this.cachedAeStacks[slot];
                FluidStack newFS = tankProperties[slot].getContents();
                this.handlePossibleSlotChanges(slot, oldAEFS, newFS, changes);
            }
            if (slots < this.cachedAeStacks.length) {
                for (slot = slots; slot < this.cachedAeStacks.length; ++slot) {
                    IAEFluidStack aeStack = this.cachedAeStacks[slot];
                    if (aeStack == null) continue;
                    IAEFluidStack a = aeStack.copy();
                    a.setStackSize(-a.getStackSize());
                    changes.add(a);
                }
                this.cachedAeStacks = Arrays.copyOf(this.cachedAeStacks, slots);
            }
            return changes;
        }

        public IItemList<IAEFluidStack> getAvailableItems(IItemList<IAEFluidStack> out) {
            Arrays.stream(this.cachedAeStacks).forEach(out::add);
            return out;
        }

        private void handlePossibleSlotChanges(int slot, IAEFluidStack oldAeFS, FluidStack newFS, List<IAEFluidStack> changes) {
            if (oldAeFS != null && oldAeFS.getFluidStack().isFluidEqual(newFS)) {
                this.handleStackSizeChanged(slot, oldAeFS, newFS, changes);
            } else {
                this.handleFluidChanged(slot, oldAeFS, newFS, changes);
            }
        }

        private void handleStackSizeChanged(int slot, IAEFluidStack oldAeFS, FluidStack newFS, List<IAEFluidStack> changes) {
            long diff = (long)newFS.amount - oldAeFS.getStackSize();
            if (diff != 0L) {
                IAEFluidStack stack = oldAeFS.copy();
                stack.setStackSize(newFS.amount);
                this.cachedAeStacks[slot] = stack;
                IAEFluidStack a = stack.copy();
                a.setStackSize(diff);
                changes.add(a);
            }
        }

        private void handleFluidChanged(int slot, IAEFluidStack oldAeFS, FluidStack newFS, List<IAEFluidStack> changes) {
            this.cachedAeStacks[slot] = AEFluidStack.fromFluidStack(newFS);
            if (oldAeFS != null) {
                oldAeFS.setStackSize(-oldAeFS.getStackSize());
                changes.add(oldAeFS);
            }
            if (this.cachedAeStacks[slot] != null) {
                changes.add(this.cachedAeStacks[slot]);
            }
        }
    }
}

