/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.conduit;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.conduit.ConnectionMode;
import crazypants.enderio.base.conduit.IConduitBundle;
import crazypants.enderio.base.conduit.RaytraceResult;
import crazypants.enderio.base.conduit.geom.CollidableCache;
import crazypants.enderio.base.conduit.geom.CollidableComponent;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public interface IConduit {
    @Nonnull
    public Class<? extends IConduit> getBaseConduitType();

    @Nonnull
    public ItemStack createItem();

    @Nonnull
    default public NNList<ItemStack> getDrops() {
        return new NNList((Object[])new ItemStack[]{this.createItem()});
    }

    default public int getLightValue() {
        return 0;
    }

    public void readFromNBT(@Nonnull NBTTagCompound var1);

    public void setBundle(@Nullable IConduitBundle var1);

    @Nonnull
    public IConduitBundle getBundle() throws NullPointerException;

    default public boolean hasConnections() {
        return this.hasConduitConnections() || this.hasExternalConnections();
    }

    public boolean hasExternalConnections();

    public boolean hasConduitConnections();

    @Nonnull
    public Set<EnumFacing> getConduitConnections();

    default public boolean containsConduitConnection(@Nonnull EnumFacing dir) {
        return this.getConduitConnections().contains(dir);
    }

    public boolean canConnectToExternal(@Nonnull EnumFacing var1, boolean var2);

    @Nonnull
    public Set<EnumFacing> getExternalConnections();

    default public boolean containsExternalConnection(@Nonnull EnumFacing dir) {
        return this.getExternalConnections().contains(dir);
    }

    default public boolean isConnectedTo(@Nonnull EnumFacing dir) {
        return this.containsConduitConnection(dir) || this.containsExternalConnection(dir);
    }

    @Nonnull
    public ConnectionMode getConnectionMode(@Nonnull EnumFacing var1);

    public boolean haveCollidablesChangedSinceLastCall();

    @Nonnull
    public Collection<CollidableComponent> getCollidableComponents();

    @Nonnull
    public Collection<CollidableComponent> createCollidables(@Nonnull CollidableCache.CacheKey var1);

    @Nonnull
    public Class<? extends IConduit> getCollidableType();

    public boolean onBlockActivated(@Nonnull EntityPlayer var1, @Nonnull EnumHand var2, @Nonnull RaytraceResult var3, @Nonnull List<RaytraceResult> var4);

    public void updateEntity(@Nonnull World var1);

    @Deprecated
    @Nonnull
    default public String getConduitProbeInfo(@Nonnull EntityPlayer player) {
        return "";
    }

    default public boolean hasInternalCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return false;
    }

    @Nullable
    default public <T> T getInternalCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return null;
    }
}

