/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.conduit.item;

import crazypants.enderio.base.conduit.item.ItemFunctionUpgrade;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public enum FunctionUpgrade {
    INVENTORY_PANEL("inventory_panel_upgrade", "item.item_inventory_panel_upgrade", 1),
    EXTRACT_SPEED_UPGRADE("extract_speed_upgrade", "item.item_extract_speed_upgrade", 15){

        @Override
        public int getMaximumExtracted(int stackSize) {
            return 4 + Math.min(stackSize, this.getMaxStackSize()) * 4;
        }

        @Override
        public float getFluidSpeedMultiplier(int stackSize) {
            return 1 + Math.min(this.getMaxStackSize(), stackSize);
        }
    }
    ,
    EXTRACT_SPEED_DOWNGRADE("extract_speed_downgrade", "item.item_extract_speed_downgrade", 3){

        @Override
        public int getMaximumExtracted(int stackSize) {
            return stackSize;
        }

        @Override
        public float getFluidSpeedMultiplier(int stackSize) {
            return 0.25f * (float)stackSize;
        }
    }
    ,
    RS_CRAFTING_UPGRADE("rs_crafting_upgrade", "item.item_rs_crafting_upgrade", 1),
    RS_CRAFTING_SPEED_UPGRADE("rs_crafting_upgrade", "item.item_rs_crafting_upgrade", 15){

        @Override
        public int getMaximumExtracted(int stackSize) {
            return 4 + Math.min(stackSize, this.getMaxStackSize()) * 4;
        }
    }
    ,
    RS_CRAFTING_SPEED_DOWNGRADE("rs_crafting_speed_downgrade", "item.item_rs_crafting_speed_downgrade", 1){

        @Override
        public int getMaximumExtracted(int stackSize) {
            return 1;
        }
    };

    public static final int BASE_MAX_EXTRACTED = 4;
    @Nonnull
    public final String baseName;
    @Nonnull
    public final String iconName;
    @Nonnull
    public final String unlocName;
    private final int maxStackSize;

    public static List<ResourceLocation> resources() {
        ArrayList<ResourceLocation> res = new ArrayList<ResourceLocation>(FunctionUpgrade.values().length);
        for (FunctionUpgrade c : FunctionUpgrade.values()) {
            res.add(new ResourceLocation(c.iconName));
        }
        return res;
    }

    private FunctionUpgrade(String name, String unlocName, int maxStackSize) {
        this.baseName = name;
        this.iconName = "enderio:" + name;
        this.unlocName = unlocName;
        this.maxStackSize = maxStackSize;
    }

    public int getMaximumExtracted(int stackSize) {
        return 4;
    }

    public static int getMaximumExtracted(@Nullable FunctionUpgrade upgrade, int stackSize) {
        return upgrade == null ? 4 : upgrade.getMaximumExtracted(stackSize);
    }

    public static int getMaximumExtracted(@Nonnull ItemStack upgradeStack) {
        FunctionUpgrade upgrade = ItemFunctionUpgrade.getFunctionUpgrade(upgradeStack);
        return upgrade == null ? 4 : upgrade.getMaximumExtracted(upgradeStack.func_190916_E());
    }

    public int getMaxStackSize() {
        return this.maxStackSize;
    }

    public float getFluidSpeedMultiplier(int stackSize) {
        return 0.0f;
    }
}

