/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.config.recipes;

import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.api.addon.IEnderIOAddon;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.config.config.RecipeConfig;
import crazypants.enderio.base.config.recipes.IRecipeRoot;
import crazypants.enderio.base.config.recipes.InvalidRecipeConfigException;
import crazypants.enderio.base.config.recipes.RecipeFactory;
import crazypants.enderio.base.config.recipes.xml.AbstractConditional;
import crazypants.enderio.base.config.recipes.xml.Aliases;
import crazypants.enderio.base.config.recipes.xml.Recipes;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.xml.stream.XMLStreamException;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.ProgressManager;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public final class RecipeLoader {
    @Nonnull
    private static final String EXT = ".xml";
    @Nonnull
    private static final String RECIPES_ROOT = "recipes";
    @Nonnull
    private static final String RECIPES_USER = "recipes/user";
    @Nonnull
    private static final String RECIPES_EXAMPLES = "recipes/examples";
    private static List<Pair<String, Pair<IMCTYPE, String>>> imcRecipes = new ArrayList<Pair<String, Pair<IMCTYPE, String>>>();

    private RecipeLoader() {
    }

    public static void addRecipes() {
        ProgressManager.ProgressBar bar = ProgressManager.push((String)"XML Recipes", (int)11, (boolean)true);
        RecipeFactory recipeFactory = new RecipeFactory(EnderIO.getConfigHandler().getConfigDirectory(), "enderio");
        bar.step("Preparing Config Folder");
        recipeFactory.cleanFolder(RECIPES_ROOT);
        recipeFactory.createFolder(RECIPES_ROOT);
        recipeFactory.createFolder(RECIPES_USER);
        recipeFactory.createFolder(RECIPES_EXAMPLES);
        if (Log.isInDev()) {
            recipeFactory.placeXSD(RECIPES_ROOT);
        }
        recipeFactory.placeXSD(RECIPES_USER);
        recipeFactory.placeXSD(RECIPES_EXAMPLES);
        recipeFactory.createFileUser("recipes/user/user_recipes.xml");
        NNList coreFiles = new NNList();
        bar.step("Collecting Sub-Mods/Addons");
        List modList = Loader.instance().getModList();
        ProgressManager.ProgressBar bar2 = ProgressManager.push((String)"Mod", (int)modList.size());
        for (Object modContainer : modList) {
            bar2.step(modContainer.getName());
            Object mod = modContainer.getMod();
            if (!(mod instanceof IEnderIOAddon)) continue;
            coreFiles.addAll(((IEnderIOAddon)mod).getRecipeFiles());
            for (String filename : ((IEnderIOAddon)mod).getExampleFiles()) {
                recipeFactory.copyCore("recipes/examples/" + filename + EXT);
            }
        }
        ProgressManager.pop((ProgressManager.ProgressBar)bar2);
        Collections.sort(coreFiles, new Comparator<Triple<Integer, RecipeFactory, String>>(){

            @Override
            public int compare(Triple<Integer, RecipeFactory, String> o1, Triple<Integer, RecipeFactory, String> o2) {
                return ((Integer)o1.getLeft()).compareTo((Integer)o2.getLeft());
            }
        });
        bar.step("Collecting User Files");
        HashSet<File> userfiles = new HashSet<File>((Collection<File>)recipeFactory.listXMLFiles(RECIPES_USER));
        for (Triple triple : coreFiles) {
            RecipeFactory factory = (RecipeFactory)triple.getMiddle();
            if (factory == null) continue;
            userfiles.addAll((Collection<File>)factory.listXMLFiles(RECIPES_USER));
        }
        bar.step("Core Aliases");
        bar2 = ProgressManager.push((String)"File", (int)coreFiles.size());
        for (Triple triple : coreFiles) {
            bar2.step((String)triple.getRight());
            RecipeLoader.readCoreFile(new Aliases(), (RecipeFactory)NullHelper.first((Object[])new RecipeFactory[]{(RecipeFactory)triple.getMiddle(), recipeFactory}), "recipes/" + (String)triple.getRight());
        }
        ProgressManager.pop((ProgressManager.ProgressBar)bar2);
        bar.step("IMC Aliases");
        if (imcRecipes != null) {
            RecipeLoader.handleIMCRecipes(Aliases.class, new Aliases());
        }
        bar.step("User Aliases");
        bar2 = ProgressManager.push((String)"File", (int)userfiles.size());
        for (File file : userfiles) {
            bar2.step(file.getName());
            RecipeLoader.readUserFile(new Aliases(), recipeFactory, file.getName(), file);
        }
        ProgressManager.pop((ProgressManager.ProgressBar)bar2);
        bar.step("Core Recipes");
        Recipes config = new Recipes();
        if (((Boolean)RecipeConfig.loadCoreRecipes.get()).booleanValue()) {
            try {
                bar2 = ProgressManager.push((String)"File", (int)coreFiles.size());
                for (Triple triple : coreFiles) {
                    bar2.step((String)triple.getRight());
                    config = (Recipes)RecipeLoader.readCoreFile(new Recipes(), (RecipeFactory)NullHelper.first((Object[])new RecipeFactory[]{(RecipeFactory)triple.getMiddle(), recipeFactory}), "recipes/" + (String)triple.getRight()).addRecipes(config, IRecipeRoot.Overrides.DENY);
                }
                ProgressManager.pop((ProgressManager.ProgressBar)bar2);
            }
            catch (InvalidRecipeConfigException e) {
                RecipeLoader.recipeError((String)NullHelper.first((Object[])new String[]{e.getFilename(), "Core Recipes"}), e.getMessage());
            }
        } else {
            Log.warn("Ender IO core recipe loading has been disabled in the configuration.");
            Log.warn("This is valid, but do NOT report recipe errors to the Ender IO team!");
        }
        bar.step("IMC Recipes");
        if (imcRecipes != null) {
            config = RecipeLoader.handleIMCRecipes(Recipes.class, config);
            imcRecipes = null;
        }
        bar.step("User Recipes");
        bar2 = ProgressManager.push((String)"File", (int)userfiles.size());
        for (File file : userfiles) {
            bar2.step(file.getName());
            Recipes userFile = RecipeLoader.readUserFile(new Recipes(), recipeFactory, file.getName(), file);
            if (userFile == null) continue;
            try {
                config = (Recipes)userFile.addRecipes(config, IRecipeRoot.Overrides.ALLOW);
            }
            catch (InvalidRecipeConfigException e) {
                RecipeLoader.recipeError((String)NullHelper.first((Object[])new String[]{e.getFilename(), file.getName()}), e.getMessage());
            }
        }
        ProgressManager.pop((ProgressManager.ProgressBar)bar2);
        bar.step("Registering Recipes");
        config.register("");
        bar.step("Post Registration");
        bar2 = ProgressManager.push((String)"Mod", (int)modList.size());
        for (ModContainer modContainer : modList) {
            bar2.step(modContainer.getName());
            Object mod = modContainer.getMod();
            if (!(mod instanceof IEnderIOAddon)) continue;
            ((IEnderIOAddon)mod).postRecipeRegistration();
        }
        ProgressManager.pop((ProgressManager.ProgressBar)bar2);
        ProgressManager.pop((ProgressManager.ProgressBar)bar);
    }

    /*
     * WARNING - void declaration
     */
    @Nonnull
    private static <T extends IRecipeRoot> T handleIMCRecipes(@Nonnull Class<T> target, @Nonnull T config) {
        try {
            ProgressManager.ProgressBar bar = ProgressManager.push((String)"IMC", (int)imcRecipes.size());
            HashMap<Object, void> targets = new HashMap<Object, void>();
            for (Pair<String, Pair<IMCTYPE, String>> pair : imcRecipes) {
                bar.step((String)pair.getKey());
                try {
                    void var6_13;
                    IRecipeRoot iRecipeRoot;
                    IRecipeRoot iRecipeRoot2 = iRecipeRoot = targets.containsKey(pair.getKey()) ? (IRecipeRoot)targets.get(pair.getKey()) : (IRecipeRoot)target.newInstance();
                    if (((Pair)pair.getValue()).getKey() == IMCTYPE.XML) {
                        try (InputStream is = IOUtils.toInputStream((String)((String)((Pair)pair.getValue()).getValue()), (Charset)Charset.forName("UTF-8"));){
                            IRecipeRoot iRecipeRoot3 = RecipeFactory.readStax(iRecipeRoot, RECIPES_ROOT, is, "IMC from mod '" + (String)pair.getKey() + "'");
                        }
                    } else {
                        IRecipeRoot iRecipeRoot4 = RecipeFactory.readFileIMC(iRecipeRoot, RECIPES_ROOT, (String)((Pair)pair.getValue()).getValue());
                    }
                    targets.put(pair.getKey(), var6_13);
                }
                catch (InvalidRecipeConfigException invalidRecipeConfigException) {
                    Log.error("Invalid recipe while parsing IMC:");
                    invalidRecipeConfigException.printStackTrace();
                    Log.error("IMC message:\n" + (String)((Pair)pair.getValue()).getValue());
                    RecipeLoader.recipeError((String)NullHelper.first((Object[])new String[]{invalidRecipeConfigException.getFilename(), "IMC from the mod '" + (String)pair.getKey() + "'"}), invalidRecipeConfigException.getMessage());
                }
                catch (IOException iOException) {
                    Log.error("IO error while parsing IMC:");
                    iOException.printStackTrace();
                    Log.error("IMC message:\n" + (String)((Pair)pair.getValue()).getValue());
                    RecipeLoader.recipeError("IMC from the mod '" + (String)pair.getKey() + "'", "IO error while parsing string: " + iOException.getMessage());
                }
                catch (XMLStreamException xMLStreamException) {
                    Log.error("IMC has malformed XML:");
                    xMLStreamException.printStackTrace();
                    Log.error("IMC message:\n" + (String)((Pair)pair.getValue()).getValue());
                    RecipeLoader.recipeError("IMC from the mod '" + (String)pair.getKey() + "'", "IMC has malformed XML: " + xMLStreamException.getMessage());
                }
            }
            ProgressManager.pop((ProgressManager.ProgressBar)bar);
            bar = ProgressManager.push((String)"IMC", (int)targets.size());
            IRecipeRoot collector = (IRecipeRoot)NullHelper.notnullJ(target.newInstance(), (String)"Class.newInstance()");
            for (Map.Entry entry : targets.entrySet()) {
                bar.step((String)entry.getKey());
                try {
                    ((IRecipeRoot)entry.getValue()).enforceValidity();
                    collector = ((IRecipeRoot)entry.getValue()).addRecipes(collector, IRecipeRoot.Overrides.WARN);
                }
                catch (InvalidRecipeConfigException e) {
                    Log.error("Invalid recipe while parsing IMC:");
                    e.printStackTrace();
                    RecipeLoader.recipeError((String)NullHelper.first((Object[])new String[]{e.getFilename(), "IMC from the mod '" + (String)entry.getKey() + "'"}), e.getMessage());
                }
            }
            ProgressManager.pop((ProgressManager.ProgressBar)bar);
            List<AbstractConditional> list = collector.getRecipes();
            if (!list.isEmpty()) {
                Log.info("Valid IMC recipes to be processed:");
                for (AbstractConditional recipe : list) {
                    Log.info(" * " + recipe.getName() + " from " + recipe.getSource());
                }
            }
            try {
                return collector.addRecipes(config, IRecipeRoot.Overrides.ALLOW);
            }
            catch (InvalidRecipeConfigException invalidRecipeConfigException) {
                throw new RuntimeException(invalidRecipeConfigException);
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    private static <T extends IRecipeRoot> T readUserFile(T target, RecipeFactory recipeFactory, String filename, File file) {
        try {
            T recipes = RecipeFactory.readFileUser(target, RECIPES_ROOT, filename, file);
            if (recipes.isValid()) {
                recipes.enforceValidity();
                return recipes;
            }
        }
        catch (InvalidRecipeConfigException e) {
            RecipeLoader.recipeError((String)NullHelper.first((Object[])new String[]{e.getFilename(), filename}), e.getMessage());
        }
        catch (IOException e) {
            Log.error("IO error while reading file:");
            e.printStackTrace();
            RecipeLoader.recipeError(filename, "IO error while reading file: " + e.getMessage());
        }
        catch (XMLStreamException e) {
            Log.error("File has malformed XML:");
            e.printStackTrace();
            RecipeLoader.recipeError(filename, "File has malformed XML: " + e.getMessage());
        }
        return null;
    }

    private static <T extends IRecipeRoot> T readCoreFile(T target, RecipeFactory recipeFactory, String filename) {
        try {
            recipeFactory.copyCore(filename + (Log.isInDev() ? EXT : ".pdf"));
            T recipes = recipeFactory.readCoreFile(target, RECIPES_ROOT, filename + EXT);
            if (recipes.isValid()) {
                recipes.enforceValidity();
                return recipes;
            }
            RecipeLoader.recipeError(filename, "File is empty or invalid");
        }
        catch (InvalidRecipeConfigException e) {
            RecipeLoader.recipeError((String)NullHelper.first((Object[])new String[]{e.getFilename(), filename + EXT}), e.getMessage());
        }
        catch (IOException e) {
            Log.error("IO error while reading file:");
            e.printStackTrace();
            RecipeLoader.recipeError(filename + EXT, "IO error while reading file: " + e.getMessage());
        }
        catch (XMLStreamException e) {
            Log.error("File has malformed XML:");
            e.printStackTrace();
            RecipeLoader.recipeError(filename + EXT, "File has malformed XML: " + e.getMessage());
        }
        return target;
    }

    public static void addIMCRecipe(String sender, boolean isFile, String recipe) throws XMLStreamException, IOException {
        if (imcRecipes != null) {
            imcRecipes.add((Pair<String, Pair<IMCTYPE, String>>)Pair.of((Object)sender, (Object)Pair.of((Object)((Object)(isFile ? IMCTYPE.FILE : IMCTYPE.XML)), (Object)recipe)));
        } else {
            try {
                Recipes recipes;
                if (!isFile) {
                    try (InputStream is = IOUtils.toInputStream((String)recipe, (Charset)Charset.forName("UTF-8"));){
                        recipes = RecipeFactory.readStax(new Recipes(), RECIPES_ROOT, is, "IMC from mod '" + sender + "'");
                    }
                } else {
                    recipes = RecipeFactory.readFileIMC(new Recipes(), RECIPES_ROOT, recipe);
                }
                recipes.enforceValidity();
                recipes.register("IMC recipes");
                return;
            }
            catch (InvalidRecipeConfigException e) {
                RecipeLoader.recipeError(recipe + " (IMC from other mod)", e.getMessage());
            }
            catch (IOException e) {
                Log.error("IO error while parsing string:");
                e.printStackTrace();
                RecipeLoader.recipeError("IMC from other mod", "IO error while parsing string: " + e.getMessage());
            }
            catch (XMLStreamException e) {
                Log.error("IMC has malformed XML:");
                e.printStackTrace();
                RecipeLoader.recipeError("IMC from other mod", "IMC has malformed XML: " + e.getMessage());
            }
        }
    }

    private static void recipeError(String filename, String message) {
        if (((Boolean)RecipeConfig.loadCoreRecipes.get()).booleanValue()) {
            EnderIO.proxy.stopWithErrorScreen("=======================================================================", "== ENDER IO FATAL RECIPE ERROR ==", "=======================================================================", "Cannot register recipes as configured. This means that either", "your custom recipe files have an error or another mod does bad", "things to vanilla items or the Ore Dictionary.", "=======================================================================", "== Bad file ==", filename, "=======================================================================", "== Error Message ==", message, "=======================================================================", "", "=======================================================================", "Note: If this is a modpack, report to the modpack author, not to", "the Ender IO team.", "=======================================================================");
        } else {
            EnderIO.proxy.stopWithErrorScreen("=======================================================================", "== ENDER IO FATAL RECIPE ERROR ==", "=======================================================================", "Cannot register recipes as configured. This means that your custom ", "recipe files have an error.", "=======================================================================", "== Bad file ==", filename, "=======================================================================", "== Error Message ==", message, "=======================================================================", "", "=======================================================================", "Do NOT report this to the Ender IO team. If this is a modpack, report", "to the modpack author. If not, YOU made a mistake.", "=======================================================================");
        }
    }

    private static enum IMCTYPE {
        XML,
        FILE;

    }
}

