/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.config.recipes.xml;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import crazypants.enderio.base.config.recipes.IRecipeRoot;
import crazypants.enderio.base.config.recipes.xml.AbstractConditional;
import crazypants.enderio.base.config.recipes.xml.Alias;
import crazypants.enderio.base.config.recipes.xml.Aliases;
import crazypants.enderio.base.config.recipes.xml.ConditionConfig;
import crazypants.enderio.base.config.recipes.xml.ConditionDependency;
import java.lang.reflect.Type;
import java.util.Optional;
import javax.annotation.Nullable;

public class Serializer {
    private static final Gson GSON_INSTANCE = new GsonBuilder().registerTypeAdapter(ConditionConfig.class, (Object)new ConditionConfigSerializer()).registerTypeAdapter(ConditionDependency.class, (Object)new ConditionDependencySerializer()).registerTypeAdapter(Alias.class, (Object)new AliasSerializer()).registerTypeAdapter(Aliases.class, (Object)new AliasesSerializer()).create();

    public static String serialize(IRecipeRoot src) {
        return GSON_INSTANCE.toJson((Object)src);
    }

    static <T> void addListOptional(JsonObject jsonobject, String name, Iterable<T> list, JsonSerializationContext context) {
        JsonArray jsonArray = new JsonArray();
        for (T elem : list) {
            jsonArray.add(context.serialize(elem));
        }
        if (jsonArray.size() > 0) {
            jsonobject.add(name, (JsonElement)jsonArray);
        }
    }

    static <T> void addOptional(JsonObject jsonobject, String name, Optional<T> value, JsonSerializationContext context) {
        if (value.isPresent()) {
            jsonobject.add(name, context.serialize(value.get()));
        }
    }

    public static class AliasesSerializer
    implements JsonSerializer<Aliases> {
        public JsonArray serialize(@Nullable Aliases src, @Nullable Type typeOfSrc, @Nullable JsonSerializationContext context) {
            JsonArray jsonArray = new JsonArray();
            for (Alias elem : src.getAliases()) {
                jsonArray.add(context.serialize((Object)elem));
            }
            return jsonArray;
        }
    }

    public static class AliasSerializer
    extends AbstractConditionalSerializer<Alias> {
        @Override
        public JsonObject serialize(@Nullable Alias src, @Nullable Type typeOfSrc, @Nullable JsonSerializationContext context) {
            JsonObject jsonobject = super.serialize(src, typeOfSrc, context);
            jsonobject.addProperty("name", src.getName());
            jsonobject.addProperty("item", src.getItem());
            return jsonobject;
        }
    }

    public static abstract class AbstractConditionalSerializer<A extends AbstractConditional>
    implements JsonSerializer<A> {
        public JsonObject serialize(@Nullable A src, @Nullable Type typeOfSrc, @Nullable JsonSerializationContext context) {
            JsonObject jsonobject = new JsonObject();
            Serializer.addListOptional(jsonobject, "config", ((AbstractConditional)src).getConfigReferences(), context);
            Serializer.addListOptional(jsonobject, "dependency", ((AbstractConditional)src).getDependencies(), context);
            return jsonobject;
        }
    }

    public static class ConditionDependencySerializer
    implements JsonSerializer<ConditionDependency> {
        public JsonObject serialize(@Nullable ConditionDependency src, @Nullable Type typeOfSrc, @Nullable JsonSerializationContext context) {
            JsonObject jsonobject = new JsonObject();
            Serializer.addOptional(jsonobject, "item", src.getItemString(), context);
            Serializer.addOptional(jsonobject, "mod", src.getModString(), context);
            Serializer.addOptional(jsonobject, "upgrade", src.getUpgradeString(), context);
            jsonobject.addProperty("reverse", Boolean.valueOf(src.isReverse()));
            return jsonobject;
        }
    }

    public static class ConditionConfigSerializer
    implements JsonSerializer<ConditionConfig> {
        public JsonObject serialize(@Nullable ConditionConfig src, @Nullable Type typeOfSrc, @Nullable JsonSerializationContext context) {
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("name", src.getName());
            jsonobject.addProperty("section", src.getSection());
            jsonobject.addProperty("value", Boolean.valueOf(src.getValue()));
            return jsonobject;
        }
    }
}

