/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.farming.farmers;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.api.farm.IHarvestResult;
import crazypants.enderio.util.NNPair;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;

public class HarvestResult
implements IHarvestResult {
    @Nonnull
    private final NNList<NNPair<BlockPos, ItemStack>> drops;
    @Nonnull
    private final NNList<BlockPos> harvestedBlocks;

    public HarvestResult(@Nonnull List<NNPair<BlockPos, ItemStack>> drops, @Nonnull List<BlockPos> harvestedBlocks) {
        this.drops = NNList.wrap(drops);
        this.harvestedBlocks = NNList.wrap(harvestedBlocks);
    }

    public HarvestResult(@Nonnull NNList<NNPair<BlockPos, ItemStack>> drops, @Nonnull NNList<BlockPos> harvestedBlocks) {
        this.drops = drops;
        this.harvestedBlocks = harvestedBlocks;
    }

    public HarvestResult(@Nonnull NNList<NNPair<BlockPos, ItemStack>> drops, BlockPos harvestedBlock) {
        this.drops = drops;
        this.harvestedBlocks = new NNList();
        this.harvestedBlocks.add((Object)harvestedBlock);
    }

    public HarvestResult(BlockPos harvestedBlock) {
        this();
        this.harvestedBlocks.add((Object)harvestedBlock);
    }

    public HarvestResult() {
        this.drops = new NNList();
        this.harvestedBlocks = new NNList();
    }

    @Nonnull
    public NNList<NNPair<BlockPos, ItemStack>> getDrops() {
        return this.drops;
    }

    @Override
    public void addDrop(@Nonnull BlockPos pos, @Nonnull ItemStack stack) {
        this.drops.add(NNPair.of(pos, stack));
    }

    @Nonnull
    public NNList<BlockPos> getHarvestedBlocks() {
        return this.harvestedBlocks;
    }
}

