/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.farming.farmers;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.api.farm.FarmNotification;
import crazypants.enderio.api.farm.FarmingAction;
import crazypants.enderio.api.farm.IFarmer;
import crazypants.enderio.api.farm.IHarvestResult;
import crazypants.enderio.base.farming.FarmingTool;
import crazypants.enderio.base.farming.farmers.CustomSeedFarmer;
import crazypants.enderio.base.farming.farmers.HarvestResult;
import crazypants.enderio.util.Prep;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ForgeEventFactory;

public class StemFarmer
extends CustomSeedFarmer {
    @Nonnull
    private static final HeightCompatator COMP = new HeightCompatator();

    public StemFarmer(@Nonnull Block plantedBlock, @Nonnull ItemStack seeds) {
        super(plantedBlock, seeds);
    }

    @Override
    public boolean prepareBlock(@Nonnull IFarmer farm, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        if (this.plantedBlock == state.func_177230_c()) {
            return true;
        }
        return this.plantFromInventory(farm, pos);
    }

    @Override
    public boolean canHarvest(@Nonnull IFarmer farm, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        return farm.getBlockState(pos.func_177984_a()).func_177230_c() == this.plantedBlock;
    }

    @Override
    public boolean canPlant(@Nonnull ItemStack stack) {
        return this.seeds.func_77969_a(stack);
    }

    @Override
    public IHarvestResult harvestBlock(final @Nonnull IFarmer farm, final @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        boolean hasHoe = farm.hasTool(FarmingTool.HOE);
        if (!hasHoe || !farm.checkAction(FarmingAction.HARVEST, FarmingTool.HOE)) {
            return new HarvestResult();
        }
        World world = farm.getWorld();
        FakePlayer joe = farm.startUsingItem(FarmingTool.HOE);
        int fortune = farm.getLootingValue(FarmingTool.HOE);
        final HarvestResult result = new HarvestResult();
        BlockPos harvestCoord = pos;
        boolean done = false;
        do {
            harvestCoord = harvestCoord.func_177972_a(EnumFacing.UP);
            IBlockState harvestState = farm.getBlockState(harvestCoord);
            if (hasHoe && this.plantedBlock == harvestState.func_177230_c()) {
                result.getHarvestedBlocks().add((Object)harvestCoord);
                NNList drops = new NNList();
                this.plantedBlock.getDrops((NonNullList)drops, (IBlockAccess)world, harvestCoord, state, fortune);
                float chance = ForgeEventFactory.fireBlockHarvesting((List)drops, (World)joe.field_70170_p, (BlockPos)harvestCoord, (IBlockState)state, (int)fortune, (float)1.0f, (boolean)false, (EntityPlayer)joe);
                for (ItemStack drop : drops) {
                    if (!(world.field_73012_v.nextFloat() <= chance)) continue;
                    result.addDrop(pos, drop.func_77946_l());
                }
                farm.registerAction(FarmingAction.HARVEST, FarmingTool.HOE, harvestState, harvestCoord);
                hasHoe = farm.hasTool(FarmingTool.HOE);
                continue;
            }
            if (!hasHoe) {
                farm.setNotification(FarmNotification.NO_HOE);
            }
            done = true;
        } while (!done);
        NNList.wrap(farm.endUsingItem(FarmingTool.HOE)).apply((NNList.Callback)new NNList.Callback<ItemStack>(){

            public void apply(@Nonnull ItemStack drop) {
                result.addDrop(pos, drop.func_77946_l());
            }
        });
        NNList toClear = new NNList(result.getHarvestedBlocks());
        Collections.sort(toClear, COMP);
        toClear.apply((NNList.Callback)new NNList.Callback<BlockPos>(){

            public void apply(@Nonnull BlockPos coord) {
                farm.getWorld().func_175698_g(coord);
            }
        });
        return result;
    }

    @Override
    protected boolean plantFromInventory(@Nonnull IFarmer farm, @Nonnull BlockPos bc) {
        World world = farm.getWorld();
        if (this.canPlant(farm, world, bc) && Prep.isValid(farm.takeSeedFromSupplies(this.seeds, bc, true)) && this.plant(farm, world, bc)) {
            farm.takeSeedFromSupplies(this.seeds, bc, false);
            return true;
        }
        return false;
    }

    private static class HeightCompatator
    implements Comparator<BlockPos> {
        private HeightCompatator() {
        }

        @Override
        public int compare(BlockPos o1, BlockPos o2) {
            return -Integer.compare(o1.func_177956_o(), o2.func_177956_o());
        }
    }
}

