/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.item.darksteel.upgrade.sound;

import com.enderio.core.common.util.Util;
import com.enderio.core.common.vecmath.Vector3d;
import crazypants.enderio.base.config.config.DarkSteelConfig;
import crazypants.enderio.base.item.darksteel.upgrade.sound.SoundParticle;
import java.util.ArrayList;
import java.util.concurrent.ArrayBlockingQueue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.client.event.sound.PlaySoundSourceEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="enderio", value={Side.CLIENT})
public class SoundDetector {
    private static final int MAX_PARTICLES = 64;
    private static final ArrayBlockingQueue<SoundSource> soundQueue = new ArrayBlockingQueue(64);
    private static boolean enabled = false;

    @SubscribeEvent
    public static void onSound(PlaySoundSourceEvent evt) {
        if (enabled && soundQueue.size() < 64) {
            switch (evt.getSound().func_184365_d()) {
                case BLOCKS: {
                    soundQueue.offer(new SoundSource(evt.getSound().func_147649_g(), evt.getSound().func_147654_h(), evt.getSound().func_147651_i(), evt.getSound().func_147653_e(), false));
                    break;
                }
                case AMBIENT: 
                case HOSTILE: 
                case NEUTRAL: 
                case PLAYERS: {
                    soundQueue.offer(new SoundSource(evt.getSound().func_147649_g(), evt.getSound().func_147654_h(), evt.getSound().func_147651_i(), evt.getSound().func_147653_e(), true));
                    break;
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (!enabled) {
            return;
        }
        ArrayList sounds = new ArrayList(64);
        soundQueue.drainTo(sounds);
        try {
            Minecraft minecraft = Minecraft.func_71410_x();
            Vector3d eye = Util.getEyePositionEio((EntityPlayer)minecraft.field_71439_g);
            for (SoundSource ss : sounds) {
                double distSq = ss.pos.distanceSquared(eye);
                int n = ss.isEntity ? 4 : 49;
                int minDist = n;
                if (!(distSq > (double)minDist) || !(distSq <= (double)((Integer)DarkSteelConfig.soundLocatorRange.get() * (Integer)DarkSteelConfig.soundLocatorRange.get()))) continue;
                minecraft.field_71452_i.func_78873_a((Particle)new SoundParticle(minecraft.field_71439_g.field_70170_p, ss));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static void setEnabled(boolean enabled) {
        SoundDetector.enabled = enabled;
    }

    public static class SoundSource {
        Vector3d pos;
        float volume;
        boolean isEntity;

        public SoundSource(Entity ent, float volume) {
            AxisAlignedBB bb = ent.func_174813_aQ();
            this.pos = new Vector3d(bb.field_72340_a + (bb.field_72336_d - bb.field_72340_a) / 2.0, bb.field_72338_b + (bb.field_72337_e - bb.field_72338_b) / 2.0, bb.field_72339_c + (bb.field_72334_f - bb.field_72339_c) / 2.0);
            this.volume = volume;
            this.isEntity = true;
        }

        public SoundSource(double x, double y, double z, float volume, boolean isEntity) {
            this.pos = new Vector3d(x, y, z);
            this.volume = volume;
            this.isEntity = isEntity;
        }
    }
}

